#ifndef __SH7764FB_H__
#define __SH7764FB_H__

#define W480 1
#define W800 0
#define W800X600 0
#define W1024 0

#ifdef __KERNEL__

#ifndef FBIO_WAITFORVSYNC
#define FBIO_WAITFORVSYNC       _IOW('F', 0x20, u_int32_t)
#endif

#define VDC2_IRQ	51
#define G2D_IRQ		60

#define FB_IOBASE	0xFFEA0000

#define VDC2CLKCR	0xFFC80004
#define PTIO_H		0xFFF1001C
#define PTIO_I		0xFFF10020
#define PTDAT_H		0xFFF1005C
#define PTDAT_I		0xFFF10060
#define PTSEL_G		0xFFF10098
#define PTSEL_H		0xFFF1009C
#define PTSEL_I		0xFFF100A0
#define PTSEL_J		0xFFF100A4
#define PTSEL_K		0xFFF100A8

#define SCLR		(FB_IOBASE+0x000)
#define SR		(FB_IOBASE+0x004)
#define SRCR		(FB_IOBASE+0x008)
#define IER		(FB_IOBASE+0x00C)
#define ICIDR		(FB_IOBASE+0x010)
#define RTN0R		(FB_IOBASE+0x040)
#define RTN1R		(FB_IOBASE+0x044)
#define DLSAR		(FB_IOBASE+0x048) /* Display list start address */
#define SSAR		(FB_IOBASE+0x04C) 
#define RSAR		(FB_IOBASE+0x050)
#define WSAR		(FB_IOBASE+0x054)
#define SSTRR		(FB_IOBASE+0x058)
#define DSTRR		(FB_IOBASE+0x05C)
#define ENDCVR		(FB_IOBASE+0x060)
#define STCR		(FB_IOBASE+0x080) /* Source transparent color */
#define DTCR		(FB_IOBASE+0x084) /* Destination transparent color */
#define ALPHR		(FB_IOBASE+0x088) /* Alpha */
#define COFSR		(FB_IOBASE+0x08C) /* Color offset */
#define RCRL		(FB_IOBASE+0x0C0) /* Rendering control */
#define CSTR		(FB_IOBASE+0x0C4) /* Command status */
#define CURR		(FB_IOBASE+0x0C8) /* Current pointer */
#define LCOR		(FB_IOBASE+0x0CC)
#define SCLMAR		(FB_IOBASE+0x0D0)
#define UCLMIR		(FB_IOBASE+0x0D4) /* User clip min */
#define UCLMAR		(FB_IOBASE+0x0D8) /* User clip max */
#define RUCLMIR		(FB_IOBASE+0x0DC) /* Relative user clip min */
#define RUCLMAR		(FB_IOBASE+0x0E0) /* Relative user clip max */
#define RCL2R		(FB_IOBASE+0x0F0) /* Rendering control 2 */
#define POFSR		(FB_IOBASE+0x0F8) /* Pattern offset */

#define SGMODE		0xFFEB0000
#define SGINTCNT	0xFFEB0004	   /* int control      */
#define SYNCNT		0xFFEB0008	   /* SYNC control     */
#define EXTSYNCNT	0xFFEB000C	   /* EXT sync control */
#define SYNSIZE		0xFFEB0104	   /* SYNC size        */
#define VSYNCTIM	0xFFEB0108	   /* VSYNC control    */
#define HSYNCTIM	0xFFEB010C	   /* HSYNC control    */
#define CLSTIM		0xFFEB0110	   /* Clock sig timing */
#define SPLTIM		0xFFEB0118	   /* sampling timing  */
#define COMTIM		0xFFEB011C	   /* gate timing      */
#define SGDESTART	0xFFEB0120	   /* SGDE start       */
#define SGDESIZE	0xFFEB0124	   /* SGDE Size        */
#define CDECRKY		0xFFEB0128	   /* CDE Cromaky      */
#define T1004CNT	0xFFEB0200	   /* T-1004 control   */
#define T1004OFFSET	0xFFEB0204	   /* T-1004 offset    */

#define GROP_OF(x)	(0xFFEC0000+x*0x00010000)
#define GRCMEN(x)	(GROP_OF(x)+0x000)
#define GRCBUSCNT(x)	(GROP_OF(x)+0x004)
#define GROPSADR(x)	(GROP_OF(x)+0x308)
#define GROPSWH(x)	(GROP_OF(x)+0x30C)
#define GROPSOFST(x)	(GROP_OF(x)+0x310)
#define GROPDPHV(x)	(GROP_OF(x)+0x314) /* Graphics  */
#define GROPEWH(x)	(GROP_OF(x)+0x318) /* Graphics video area	*/
#define GROPEDPHV(x)	(GROP_OF(x)+0x31C) /* Graphics video area timing*/
#define GROPEDPA(x)	(GROP_OF(x)+0x320) /* Graphics video alpha ctrl */
#define GROPCRKY0(x)	(GROP_OF(x)+0x324) /* Graphics chromakey ctrl */
#define GROPCRKY1(x)	(GROP_OF(x)+0x328) /* raphics chroma color set */
#define GROPBASERGB(x)	(GROP_OF(x)+0x32C) /* Graphic base RGB		*/

//#define VRAM P1SEGADDR((CONFIG_MEMORY_START + CONFIG_MEMORY_SIZE) - CONFIG_FB_MEMSIZE)
#define FB_ACCEL_SH7764_G2D 0x7764

#if W480
#define XRES 480
#define YRES 272
#define SGDE_START_H	16
#define SGDE_START_V	1
#define SYN_WIDTH	(491+16)
#define SYN_HEIGHT	(283+1)
#elif W800
#define XRES 800
#define YRES 480
#define SGDE_START_H	16
#define SGDE_START_V	1
#define SYN_WIDTH	(XRES + SGDE_START_H + 2) /* 818 */
#define SYN_HEIGHT	(YRES + SGDE_START_V + 6)  /* 487 */
#elif W800X600
#define XRES 800
#define YRES 600
#define SGDE_START_H	16
#define SGDE_START_V	1
#define SYN_WIDTH	(XRES + SGDE_START_H + 2) /* 818 */
#define SYN_HEIGHT	(YRES + SGDE_START_V + 7)  /* 608 */
#elif W1024
#define XRES 1024
#define YRES 768
#define SGDE_START_H	16
#define SGDE_START_V	1
#define SYN_WIDTH	(XRES + SGDE_START_H + 2) /* 818 */
#define SYN_HEIGHT	(YRES + SGDE_START_V + 7)  /* 608 */
#else
#define XRES 640
#define YRES 480
#define SGDE_START_H	16 // 124
#define SGDE_START_V	1 // 20
#define SYN_WIDTH	858 // 858
#define SYN_HEIGHT	525 // 512
#endif

#define SGDE_WIDTH	XRES
#define SGDE_HEIGHT	YRES

#if !(SYN_HEIGHT > SGDE_HEIGHT+SGDE_START_V)
#error SYN_HEIGHT
#endif

#if !(SYN_WIDTH > SGDE_WIDTH+SGDE_START_H)
#error SYN_WIDTH
#endif

#endif	/* __KERNEL__ */

#include <linux/types.h>
#include <linux/ioctl.h>

#define G2D_MAGIC		'g'
#define G2DIOC_LINEA		_IOWR(G2D_MAGIC, 0x01, unsigned long)
#define G2DIOC_LINEB		_IOWR(G2D_MAGIC, 0x02, unsigned long)
#define G2DIOC_LINEC		_IOWR(G2D_MAGIC, 0x03, unsigned long)
#define G2DIOC_POLYGON4A	_IOWR(G2D_MAGIC, 0x04, unsigned long)
#define G2DIOC_POLYGON4B	_IOWR(G2D_MAGIC, 0x05, unsigned long)
#define G2DIOC_POLYGON4C	_IOWR(G2D_MAGIC, 0x06, unsigned long)
#define G2DIOC_DST_SCREEN	_IOWR(G2D_MAGIC, 0x07, unsigned long)
#define G2DIOC_SRC_SCREEN	_IOWR(G2D_MAGIC, 0x08, unsigned long)
#define G2DIOC_SET_CLIP		_IOWR(G2D_MAGIC, 0x09, unsigned long)
#define G2DIOC_GET_CLIP		_IOWR(G2D_MAGIC, 0x0A, unsigned long)
#define G2DIOC_MMAP_INFO	_IOWR(G2D_MAGIC, 0x0B, unsigned long)
#define G2DIOC_WAIT_UNTIL_IDLE	_IOWR(G2D_MAGIC, 0x0C, unsigned long)
#define G2DIOC_CANCEL_WAIT	_IOWR(G2D_MAGIC, 0x0D, unsigned long)
#define G2DIOC_CACHE_FLUSH	_IOWR(G2D_MAGIC, 0x0E, unsigned long)
#define G2DIOC_GET_DST_SCREEN	_IOWR(G2D_MAGIC, 0x0F, unsigned long)
#define G2DIOC_GET_SRC_SCREEN	_IOWR(G2D_MAGIC, 0x10, unsigned long)
#define G2DIOC_BITBLTA		_IOWR(G2D_MAGIC, 0x11, unsigned long)
#define G2DIOC_BITBLTB		_IOWR(G2D_MAGIC, 0x12, unsigned long)
#define G2DIOC_BITBLTC		_IOWR(G2D_MAGIC, 0x13, unsigned long)
#define G2DIOC_WPR		_IOWR(G2D_MAGIC, 0x14, unsigned long)
#define G2DIOC_DL_RAW		_IOWR(G2D_MAGIC, 0x20, unsigned long)
#define G2DIOC_WAIT_IDLE	_IOWR(G2D_MAGIC, 0x21, unsigned long)
#define G2DIOC_SET_SSTRR	_IOWR(G2D_MAGIC, 0x15, unsigned long)

#define G2D_DL_POLYGON4A	0x82000000
#define G2D_DL_POLYGON4B	0x81000000
#define G2D_DL_POLYGON4C	0x80000000
#define G2D_DL_LINEA		0xB2000000
#define G2D_DL_LINEB		0xB1000000
#define G2D_DL_LINEC		0xB0000000
#define G2D_DL_LINED		0xB3000000
#define G2D_DL_RLINEA		0xB6000000
#define G2D_DL_RLINEB		0xB5000000
#define G2D_DL_RLINEC		0xB4000000
#define G2D_DL_RLINED		0xB7000000
#define G2D_DL_FTRAPC		0xD0000000
#define G2D_DL_RFTRAPC		0xD4000000
#define G2D_DL_CLRWC		0xE0000000
#define G2D_DL_LINEWC		0xF0000000
#define G2D_DL_RLINEWC		0xF4000000
#define G2D_DL_BITBLTA		0xA2000000
#define G2D_DL_BITBLTB		0xA1000000
#define G2D_DL_BITBLTC		0xA0000000
#define G2D_DL_MOVE		0x48000000
#define G2D_DL_RMOVE		0x4C000000
#define G2D_DL_LCOFS		0x40000000
#define G2D_DL_RLCOFS		0x44000000
#define G2D_DL_WPR		0x18000000
#define G2D_DL_JUMP		0x28000000
#define G2D_DL_GOSUB		0x30000000
#define G2D_DL_RET		0x38000000
#define G2D_DL_NOP		0x08000000
#define G2D_DL_VBKEM		0x10000000
#define G2D_DL_TRAP		0x00000000

#define G2D_DM_CLIP	0x2000
#define G2D_DM_RCLIP	0x1000
#define G2D_DM_STRANS	0x0800
#define G2D_DM_DTRANS	0x0400
#define G2D_DM_WORK	0x0200
#define G2D_DM_SS	0x0100
#define G2D_DM_SRCDIRX	0x0040
#define G2D_DM_AE	0x0002

struct g2d_polygon4c {
	u_int16_t draw_mode;
	u_int16_t color;
	u_int16_t dx1, dy1, dx2, dy2, dx3, dy3, dx4, dy4;
};

struct g2d_wpr {
	u_int16_t draw_mode;
	u_int16_t n;
	u_int16_t wregno;
	u_int32_t data[];
};

struct g2d_dl_raw {
	int size;
	u_int32_t data[];
};

#endif	       
