#ifndef __LINUX_GIORW_H
#define __LINUX_GIORW_H

#include <linux/types.h>

struct giorw {
	unsigned long addr;
	union {
		__u8 data8;
		__u16 data16;
		__u32 data32;
	};
};

#define IOC_MAGIC 'm'

#define GIORW_IOC_IOR8 _IOR(IOC_MAGIC, 1, struct giorw)
#define GIORW_IOC_IOW8 _IOW(IOC_MAGIC, 2, struct giorw)
#define GIORW_IOC_IOR16 _IOR(IOC_MAGIC, 3, struct giorw)
#define GIORW_IOC_IOW16 _IOW(IOC_MAGIC, 4, struct giorw)
#define GIORW_IOC_IOR32 _IOR(IOC_MAGIC, 5, struct giorw)
#define GIORW_IOC_IOW32 _IOW(IOC_MAGIC, 6, struct giorw)

#endif
