package sharin.csv.parser;

import java.util.ArrayList;
import java.util.List;

public class BasicCsvHandler implements CsvHandler {

    private final List<String[]> recordList;

    private List<String> valueList;

    private StringBuilder valueBuilder;

    public BasicCsvHandler() {
        recordList = new ArrayList<String[]>();
    }

    public void startDocument() {
        /* do nothing */
    }

    public void startRecord() {
        valueList = new ArrayList<String>();
    }

    public void startValue() {
        valueBuilder = new StringBuilder();
    }

    public void character(char ch) {
        valueBuilder.append(ch);
    }

    public void endValue() {
        valueList.add(valueBuilder.toString());
    }

    public void endRecord() {
        recordList.add(valueList.toArray(new String[valueList.size()]));
    }

    public void endDocument() {
        /* do nothing */
    }

    public String[][] getRecords() {
        return recordList.toArray(new String[recordList.size()][]);
    }
}
