/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import sharin.unlinq.BasicEnumerable;
import sharin.unlinq.Dictionary;
import sharin.unlinq.Enumerable;
import sharin.unlinq.EnumerableList;
import sharin.unlinq.Func;
import sharin.unlinq.Func2;
import sharin.unlinq.Grouping;
import sharin.unlinq.Lookup;
import sharin.unlinq.OrderedEnumerable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicOrderedEnumerable<T>
implements OrderedEnumerable<T> {
    private final Enumerable<T> enumerable;
    private final List<List<T>> listList;

    public <K> BasicOrderedEnumerable(Enumerable<T> enumerable, Func<T, K> keySelector, boolean descending) {
        this(enumerable, keySelector, descending, null);
    }

    public <K> BasicOrderedEnumerable(Enumerable<T> enumerable, Func<T, K> keySelector, boolean descending, Comparator<K> comparator) {
        List<Object> listList = null;
        if (enumerable instanceof BasicOrderedEnumerable) {
            listList = this.apply(this.toBasicOrderedEnumerable(enumerable).listList, keySelector, descending, comparator);
        } else {
            listList = new ArrayList<List<T>>();
            listList.add(enumerable.toList());
            listList = this.apply(listList, keySelector, descending, comparator);
        }
        this.listList = listList;
        ArrayList all = new ArrayList();
        for (List list : listList) {
            all.addAll(list);
        }
        this.enumerable = new BasicEnumerable(all);
    }

    private BasicOrderedEnumerable<T> toBasicOrderedEnumerable(Enumerable<T> enumerable) {
        return (BasicOrderedEnumerable)enumerable;
    }

    private <K> List<List<T>> apply(List<List<T>> prevListList, Func<T, K> keySelector, boolean descending, Comparator<K> comparator) {
        ArrayList<List<T>> currListList = new ArrayList<List<T>>();
        for (List<T> prevList : prevListList) {
            TreeMap<K, List<T>> map = this.createTreeMap(comparator);
            for (T entity : prevList) {
                K key = keySelector.call(entity);
                List<T> currList = map.get(key);
                if (currList == null) {
                    currList = new ArrayList<T>();
                    map.put(key, currList);
                }
                currList.add(entity);
            }
            Collection<List<T>> values = map.values();
            if (descending) {
                ArrayList<List<T>> list = new ArrayList<List<T>>(values);
                Collections.reverse(list);
                values = list;
            }
            currListList.addAll(values);
        }
        return currListList;
    }

    private <K> TreeMap<K, List<T>> createTreeMap(Comparator<K> comparator) {
        if (comparator == null) {
            return new TreeMap();
        }
        return new TreeMap(comparator);
    }

    @Override
    public <K> OrderedEnumerable<T> thenBy(Func<T, K> keySelector) {
        return new BasicOrderedEnumerable<T>(this, keySelector, false);
    }

    @Override
    public <K> OrderedEnumerable<T> thenBy(Func<T, K> keySelector, Comparator<K> comparator) {
        return new BasicOrderedEnumerable<T>(this, keySelector, false, comparator);
    }

    @Override
    public <K> OrderedEnumerable<T> thenByDescending(Func<T, K> keySelector) {
        return new BasicOrderedEnumerable<T>(this, keySelector, true);
    }

    @Override
    public <K> OrderedEnumerable<T> thenByDescending(Func<T, K> keySelector, Comparator<K> comparator) {
        return new BasicOrderedEnumerable<T>(this, keySelector, true, comparator);
    }

    @Override
    public <A, R> R aggregate(A seed, Func2<A, T, A> func, Func<A, R> resultSelector) {
        return this.enumerable.aggregate(seed, func, resultSelector);
    }

    @Override
    public <A> A aggregate(A seed, Func2<A, T, A> func) {
        return this.enumerable.aggregate(seed, func);
    }

    @Override
    public T aggregate(Func2<T, T, T> func) {
        return this.enumerable.aggregate(func);
    }

    @Override
    public Boolean all(Func<T, Boolean> predicate) {
        return this.enumerable.all(predicate);
    }

    @Override
    public Boolean any() {
        return this.enumerable.any();
    }

    @Override
    public Boolean any(Func<T, Boolean> predicate) {
        return this.enumerable.any(predicate);
    }

    @Override
    public Enumerable<T> concat(Enumerable<T> second) {
        return this.enumerable.concat(second);
    }

    @Override
    public boolean contains(Object value) {
        return this.enumerable.contains(value);
    }

    @Override
    public int count() {
        return this.enumerable.count();
    }

    @Override
    public int count(Func<T, Boolean> predicate) {
        return this.enumerable.count(predicate);
    }

    @Override
    public Enumerable<T> defaultIfEmpty() {
        return this.enumerable.defaultIfEmpty();
    }

    @Override
    public Enumerable<T> defaultIfEmpty(T defaultValue) {
        return this.enumerable.defaultIfEmpty(defaultValue);
    }

    @Override
    public Enumerable<T> distinct() {
        return this.enumerable.distinct();
    }

    @Override
    public T elementAt(int index) {
        return this.enumerable.elementAt(index);
    }

    @Override
    public T elementAtOrDefault(int index) {
        return this.enumerable.elementAtOrDefault(index);
    }

    @Override
    public Enumerable<T> except(Enumerable<T> second) {
        return this.enumerable.except(second);
    }

    @Override
    public T first() {
        return this.enumerable.first();
    }

    @Override
    public T first(Func<T, Boolean> predicate) {
        return this.enumerable.first(predicate);
    }

    @Override
    public T firstOrDefault() {
        return this.enumerable.firstOrDefault();
    }

    @Override
    public T firstOrDefault(Func<T, Boolean> predicate) {
        return this.enumerable.firstOrDefault(predicate);
    }

    @Override
    public <K, E, R> Enumerable<R> groupBy(Func<T, K> keySelector, Func<T, E> elementSelector, Func2<K, Enumerable<E>, R> resultSelector) {
        return this.enumerable.groupBy(keySelector, elementSelector, resultSelector);
    }

    @Override
    public <K, E> Enumerable<Grouping<K, E>> groupBy(Func<T, K> keySelector, Func<T, E> elementSelector) {
        return this.enumerable.groupBy(keySelector, elementSelector);
    }

    @Override
    public <K, R> Enumerable<R> groupBy(Func<T, K> keySelector, Func2<K, Enumerable<T>, R> resultSelector) {
        return this.enumerable.groupBy(keySelector, resultSelector);
    }

    @Override
    public <K> Enumerable<Grouping<K, T>> groupBy(Func<T, K> keySelector) {
        return this.enumerable.groupBy(keySelector);
    }

    @Override
    public <I, K, R> Enumerable<R> groupJoin(Enumerable<I> inner, Func<T, K> outerKeySelector, Func<I, K> innerKeySelector, Func2<T, Enumerable<I>, R> resultSelector) {
        return this.enumerable.groupJoin(inner, outerKeySelector, innerKeySelector, resultSelector);
    }

    @Override
    public Enumerable<T> intersect(Enumerable<T> second) {
        return this.enumerable.intersect(second);
    }

    @Override
    public Iterator<T> iterator() {
        return this.enumerable.iterator();
    }

    @Override
    public <I, K, R> Enumerable<R> join(Enumerable<I> inner, Func<T, K> outerKeySelector, Func<I, K> innerKeySelector, Func2<T, I, R> resultSelector) {
        return this.enumerable.join(inner, outerKeySelector, innerKeySelector, resultSelector);
    }

    @Override
    public T last() {
        return this.enumerable.last();
    }

    @Override
    public T last(Func<T, Boolean> predicate) {
        return this.enumerable.last(predicate);
    }

    @Override
    public T lastOrDefault() {
        return this.enumerable.lastOrDefault();
    }

    @Override
    public T lastOrDefault(Func<T, Boolean> predicate) {
        return this.enumerable.lastOrDefault(predicate);
    }

    @Override
    public long longCount() {
        return this.enumerable.longCount();
    }

    @Override
    public long longCount(Func<T, Boolean> predicate) {
        return this.enumerable.longCount(predicate);
    }

    @Override
    public T max() {
        return this.enumerable.max();
    }

    @Override
    public <R extends Comparable<R>> R max(Func<T, R> selector) {
        return this.enumerable.max(selector);
    }

    @Override
    public T min() {
        return this.enumerable.min();
    }

    @Override
    public <R extends Comparable<R>> R min(Func<T, R> selector) {
        return this.enumerable.min(selector);
    }

    @Override
    public <R> Enumerable<R> ofType(Class<R> resultClass) {
        return this.enumerable.ofType(resultClass);
    }

    @Override
    public <K> OrderedEnumerable<T> orderBy(Func<T, K> keySelector, Comparator<K> comparator) {
        return this.enumerable.orderBy(keySelector, comparator);
    }

    @Override
    public <K> OrderedEnumerable<T> orderBy(Func<T, K> keySelector) {
        return this.enumerable.orderBy(keySelector);
    }

    @Override
    public <K> OrderedEnumerable<T> orderByDescending(Func<T, K> keySelector, Comparator<K> comparator) {
        return this.enumerable.orderByDescending(keySelector, comparator);
    }

    @Override
    public <K> OrderedEnumerable<T> orderByDescending(Func<T, K> keySelector) {
        return this.enumerable.orderByDescending(keySelector);
    }

    @Override
    public Enumerable<T> reverse() {
        return this.enumerable.reverse();
    }

    @Override
    public <R> Enumerable<R> select(Func<T, R> selector) {
        return this.enumerable.select(selector);
    }

    @Override
    public <R> Enumerable<R> select(Func2<T, Integer, R> selector) {
        return this.enumerable.select(selector);
    }

    @Override
    public <C, R> Enumerable<R> selectMany(Func<T, Enumerable<C>> collectionSelector, Func2<T, C, R> resultSelector) {
        return this.enumerable.selectMany(collectionSelector, resultSelector);
    }

    @Override
    public <R> Enumerable<R> selectMany(Func<T, Enumerable<R>> selector) {
        return this.enumerable.selectMany(selector);
    }

    @Override
    public <C, R> Enumerable<R> selectMany(Func2<T, Integer, Enumerable<C>> collectionSelector, Func2<T, C, R> resultSelector) {
        return this.enumerable.selectMany(collectionSelector, resultSelector);
    }

    @Override
    public <R> Enumerable<R> selectMany(Func2<T, Integer, Enumerable<R>> selector) {
        return this.enumerable.selectMany(selector);
    }

    @Override
    public Boolean sequenceEqual(Enumerable<T> second) {
        return this.enumerable.sequenceEqual(second);
    }

    @Override
    public T single() {
        return this.enumerable.single();
    }

    @Override
    public T single(Func<T, Boolean> predicate) {
        return this.enumerable.single(predicate);
    }

    @Override
    public T singleOrDefault() {
        return this.enumerable.singleOrDefault();
    }

    @Override
    public T singleOrDefault(Func<T, Boolean> predicate) {
        return this.enumerable.singleOrDefault(predicate);
    }

    @Override
    public Enumerable<T> skip(int count) {
        return this.enumerable.skip(count);
    }

    @Override
    public Enumerable<T> skipWhile(Func<T, Boolean> predicate) {
        return this.enumerable.skipWhile(predicate);
    }

    @Override
    public Enumerable<T> skipWhile(Func2<T, Integer, Boolean> predicate) {
        return this.enumerable.skipWhile(predicate);
    }

    @Override
    public int sum() {
        return this.enumerable.sum();
    }

    @Override
    public int sum(Func<T, Integer> selector) {
        return this.enumerable.sum(selector);
    }

    @Override
    public double sumDouble() {
        return this.enumerable.sumDouble();
    }

    @Override
    public double sumDouble(Func<T, Double> selector) {
        return this.enumerable.sumDouble(selector);
    }

    @Override
    public float sumFloat() {
        return this.enumerable.sumFloat();
    }

    @Override
    public float sumFloat(Func<T, Float> selector) {
        return this.enumerable.sumFloat(selector);
    }

    @Override
    public long sumLong() {
        return this.enumerable.sumLong();
    }

    @Override
    public long sumLong(Func<T, Long> selector) {
        return this.enumerable.sumLong(selector);
    }

    @Override
    public Enumerable<T> take(int count) {
        return this.enumerable.take(count);
    }

    @Override
    public Enumerable<T> takeWhile(Func<T, Boolean> predicate) {
        return this.enumerable.takeWhile(predicate);
    }

    @Override
    public Enumerable<T> takeWhile(Func2<T, Integer, Boolean> predicate) {
        return this.enumerable.takeWhile(predicate);
    }

    @Override
    public Object[] toArray() {
        return this.enumerable.toArray();
    }

    @Override
    public <R> R[] toArray(Class<R> resultClass) {
        return this.enumerable.toArray(resultClass);
    }

    @Override
    public List<T> toList() {
        return this.enumerable.toList();
    }

    @Override
    public EnumerableList<T> toEnumerableList() {
        return this.enumerable.toEnumerableList();
    }

    @Override
    public <K, E> Lookup<K, E> toLookup(Func<T, K> keySelector, Func<T, E> elementSelector) {
        return this.enumerable.toLookup(keySelector, elementSelector);
    }

    @Override
    public <K> Lookup<K, T> toLookup(Func<T, K> keySelector) {
        return this.enumerable.toLookup(keySelector);
    }

    @Override
    public <K, E> Dictionary<K, E> toDictionary(Func<T, K> keySelector, Func<T, E> elementSelector) {
        return this.enumerable.toDictionary(keySelector, elementSelector);
    }

    @Override
    public <K> Dictionary<K, T> toDictionary(Func<T, K> keySelector) {
        return this.enumerable.toDictionary(keySelector);
    }

    @Override
    public Enumerable<T> union(Enumerable<T> second) {
        return this.enumerable.union(second);
    }

    @Override
    public Enumerable<T> where(Func<T, Boolean> predicate) {
        return this.enumerable.where(predicate);
    }

    @Override
    public Enumerable<T> where(Func2<T, Integer, Boolean> predicate) {
        return this.enumerable.where(predicate);
    }

    @Override
    public double average() {
        return this.enumerable.average();
    }

    @Override
    public double average(Func<T, Integer> selector) {
        return this.enumerable.average(selector);
    }

    @Override
    public double averageDouble() {
        return this.enumerable.averageDouble();
    }

    @Override
    public double averageDouble(Func<T, Double> selector) {
        return this.enumerable.averageDouble(selector);
    }

    @Override
    public float averageFloat() {
        return this.enumerable.averageFloat();
    }

    @Override
    public float averageFloat(Func<T, Float> selector) {
        return this.enumerable.averageFloat(selector);
    }

    @Override
    public double averageLong() {
        return this.enumerable.averageLong();
    }

    @Override
    public double averageLong(Func<T, Long> selector) {
        return this.enumerable.averageLong(selector);
    }

    @Override
    public T firstOrDefault(Func<T, Boolean> predicate, T defaultValue) {
        return this.enumerable.firstOrDefault(predicate, defaultValue);
    }

    @Override
    public T firstOrDefault(T defaultValue) {
        return this.enumerable.firstOrDefault(defaultValue);
    }

    @Override
    public T lastOrDefault(Func<T, Boolean> predicate, T defaultValue) {
        return this.enumerable.lastOrDefault(predicate, defaultValue);
    }

    @Override
    public T lastOrDefault(T defaultValue) {
        return this.enumerable.lastOrDefault(defaultValue);
    }

    @Override
    public T singleOrDefault(Func<T, Boolean> predicate, T defaultValue) {
        return this.enumerable.singleOrDefault(predicate, defaultValue);
    }

    @Override
    public T singleOrDefault(T defaultValue) {
        return this.enumerable.singleOrDefault(defaultValue);
    }

    @Override
    public T elementAtOrDefault(int index, T defaultValue) {
        return this.enumerable.elementAtOrDefault(index, defaultValue);
    }

    @Override
    public <R> Enumerable<R> cast(Class<R> resultClass) {
        return this.enumerable.cast(resultClass);
    }

    @Override
    public <K, E> Map<K, E> toMap(Func<T, K> keySelector, Func<T, E> elementSelector) {
        return this.enumerable.toMap(keySelector, elementSelector);
    }

    @Override
    public <K> Map<K, T> toMap(Func<T, K> keySelector) {
        return this.enumerable.toMap(keySelector);
    }

    @Override
    public <K, E> Map<K, List<E>> toListMap(Func<T, K> keySelector, Func<T, E> elementSelector) {
        return this.enumerable.toListMap(keySelector, elementSelector);
    }

    @Override
    public <K> Map<K, List<T>> toListMap(Func<T, K> keySelector) {
        return this.enumerable.toListMap(keySelector);
    }
}

