package sharin.unlinq;

import java.util.Iterator;

public class ConcatenatedIterator<T> implements Iterator<T> {

    private Iterator<T> iterator;

    private final Iterator<T> second;

    public ConcatenatedIterator(Iterator<T> first, Iterator<T> second) {
        this.iterator = first;
        this.second = second;
    }

    public boolean hasNext() {

        if (iterator.hasNext()) {
            return true;
        }

        if (iterator == second) {
            return false;
        }

        iterator = second;
        return iterator.hasNext();
    }

    public T next() {
        return iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

}
