package sharin.unlinq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class BasicEnumerableList<T> implements EnumerableList<T> {

    private final List<T> list;

    public BasicEnumerableList() {
        this(null);
    }

    public BasicEnumerableList(List<T> list) {

        if (list == null) {
            list = new ArrayList<T>();
        }

        this.list = list;
    }

    private Enumerable<T> getEnumerable() {
        return new BasicEnumerable<T>(list);
    }

    @Override
    public String toString() {
        return list.toString();
    }

    public void add(int index, T element) {
        list.add(index, element);
    }

    public boolean add(T o) {
        return list.add(o);
    }

    public boolean addAll(Collection<? extends T> c) {
        return list.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends T> c) {
        return list.addAll(index, c);
    }

    public void clear() {
        list.clear();
    }

    public boolean contains(Object o) {
        return list.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return list.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return list.equals(o);
    }

    public T get(int index) {
        return list.get(index);
    }

    @Override
    public int hashCode() {
        return list.hashCode();
    }

    public int indexOf(Object o) {
        return list.indexOf(o);
    }

    public boolean isEmpty() {
        return list.isEmpty();
    }

    public Iterator<T> iterator() {
        return list.iterator();
    }

    public int lastIndexOf(Object o) {
        return list.lastIndexOf(o);
    }

    public ListIterator<T> listIterator() {
        return list.listIterator();
    }

    public ListIterator<T> listIterator(int index) {
        return list.listIterator(index);
    }

    public T remove(int index) {
        return list.remove(index);
    }

    public boolean remove(Object o) {
        return list.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        return list.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return list.retainAll(c);
    }

    public T set(int index, T element) {
        return list.set(index, element);
    }

    public int size() {
        return list.size();
    }

    public List<T> subList(int fromIndex, int toIndex) {
        return list.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return list.toArray();
    }

    public <R> R[] toArray(R[] a) {
        return list.toArray(a);
    }

    public <A, R> R aggregate(A seed, Func2<A, T, A> func,
            Func<A, R> resultSelector) {
        return getEnumerable().aggregate(seed, func, resultSelector);
    }

    public <A> A aggregate(A seed, Func2<A, T, A> func) {
        return getEnumerable().aggregate(seed, func);
    }

    public T aggregate(Func2<T, T, T> func) {
        return getEnumerable().aggregate(func);
    }

    public Boolean all(Func<T, Boolean> predicate) {
        return getEnumerable().all(predicate);
    }

    public Boolean any() {
        return getEnumerable().any();
    }

    public Boolean any(Func<T, Boolean> predicate) {
        return getEnumerable().any(predicate);
    }

    public double average() {
        return getEnumerable().average();
    }

    public double average(Func<T, Integer> selector) {
        return getEnumerable().average(selector);
    }

    public double averageDouble() {
        return getEnumerable().averageDouble();
    }

    public double averageDouble(Func<T, Double> selector) {
        return getEnumerable().averageDouble(selector);
    }

    public float averageFloat() {
        return getEnumerable().averageFloat();
    }

    public float averageFloat(Func<T, Float> selector) {
        return getEnumerable().averageFloat(selector);
    }

    public double averageLong() {
        return getEnumerable().averageLong();
    }

    public double averageLong(Func<T, Long> selector) {
        return getEnumerable().averageLong(selector);
    }

    public <R> Enumerable<R> cast(Class<R> resultClass) {
        return getEnumerable().cast(resultClass);
    }

    public Enumerable<T> concat(Enumerable<T> second) {
        return getEnumerable().concat(second);
    }

    public int count() {
        return getEnumerable().count();
    }

    public int count(Func<T, Boolean> predicate) {
        return getEnumerable().count(predicate);
    }

    public Enumerable<T> defaultIfEmpty() {
        return getEnumerable().defaultIfEmpty();
    }

    public Enumerable<T> defaultIfEmpty(T defaultValue) {
        return getEnumerable().defaultIfEmpty(defaultValue);
    }

    public Enumerable<T> distinct() {
        return getEnumerable().distinct();
    }

    public T elementAt(int index) {
        return getEnumerable().elementAt(index);
    }

    public T elementAtOrDefault(int index, T defaultValue) {
        return getEnumerable().elementAtOrDefault(index, defaultValue);
    }

    public T elementAtOrDefault(int index) {
        return getEnumerable().elementAtOrDefault(index);
    }

    public Enumerable<T> except(Enumerable<T> second) {
        return getEnumerable().except(second);
    }

    public T first() {
        return getEnumerable().first();
    }

    public T first(Func<T, Boolean> predicate) {
        return getEnumerable().first(predicate);
    }

    public T firstOrDefault() {
        return getEnumerable().firstOrDefault();
    }

    public T firstOrDefault(Func<T, Boolean> predicate, T defaultValue) {
        return getEnumerable().firstOrDefault(predicate, defaultValue);
    }

    public T firstOrDefault(Func<T, Boolean> predicate) {
        return getEnumerable().firstOrDefault(predicate);
    }

    public T firstOrDefault(T defaultValue) {
        return getEnumerable().firstOrDefault(defaultValue);
    }

    public <K, E, R> Enumerable<R> groupBy(Func<T, K> keySelector,
            Func<T, E> elementSelector,
            Func2<K, Enumerable<E>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector,
                resultSelector);
    }

    public <K, E> Enumerable<Grouping<K, E>> groupBy(Func<T, K> keySelector,
            Func<T, E> elementSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector);
    }

    public <K, R> Enumerable<R> groupBy(Func<T, K> keySelector,
            Func2<K, Enumerable<T>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, resultSelector);
    }

    public <K> Enumerable<Grouping<K, T>> groupBy(Func<T, K> keySelector) {
        return getEnumerable().groupBy(keySelector);
    }

    public <I, K, R> Enumerable<R> groupJoin(Enumerable<I> inner,
            Func<T, K> outerKeySelector, Func<I, K> innerKeySelector,
            Func2<T, Enumerable<I>, R> resultSelector) {
        return getEnumerable().groupJoin(inner, outerKeySelector,
                innerKeySelector, resultSelector);
    }

    public Enumerable<T> intersect(Enumerable<T> second) {
        return getEnumerable().intersect(second);
    }

    public <I, K, R> Enumerable<R> join(Enumerable<I> inner,
            Func<T, K> outerKeySelector, Func<I, K> innerKeySelector,
            Func2<T, I, R> resultSelector) {
        return getEnumerable().join(inner, outerKeySelector, innerKeySelector,
                resultSelector);
    }

    public T last() {
        return getEnumerable().last();
    }

    public T last(Func<T, Boolean> predicate) {
        return getEnumerable().last(predicate);
    }

    public T lastOrDefault() {
        return getEnumerable().lastOrDefault();
    }

    public T lastOrDefault(Func<T, Boolean> predicate, T defaultValue) {
        return getEnumerable().lastOrDefault(predicate, defaultValue);
    }

    public T lastOrDefault(Func<T, Boolean> predicate) {
        return getEnumerable().lastOrDefault(predicate);
    }

    public T lastOrDefault(T defaultValue) {
        return getEnumerable().lastOrDefault(defaultValue);
    }

    public long longCount() {
        return getEnumerable().longCount();
    }

    public long longCount(Func<T, Boolean> predicate) {
        return getEnumerable().longCount(predicate);
    }

    public T max() {
        return getEnumerable().max();
    }

    public <R extends Comparable<R>> R max(Func<T, R> selector) {
        return getEnumerable().max(selector);
    }

    public T min() {
        return getEnumerable().min();
    }

    public <R extends Comparable<R>> R min(Func<T, R> selector) {
        return getEnumerable().min(selector);
    }

    public <R> Enumerable<R> ofType(Class<R> resultClass) {
        return getEnumerable().ofType(resultClass);
    }

    public <K> OrderedEnumerable<T> orderBy(Func<T, K> keySelector,
            Comparator<K> comparator) {
        return getEnumerable().orderBy(keySelector, comparator);
    }

    public <K> OrderedEnumerable<T> orderBy(Func<T, K> keySelector) {
        return getEnumerable().orderBy(keySelector);
    }

    public <K> OrderedEnumerable<T> orderByDescending(Func<T, K> keySelector,
            Comparator<K> comparator) {
        return getEnumerable().orderByDescending(keySelector, comparator);
    }

    public <K> OrderedEnumerable<T> orderByDescending(Func<T, K> keySelector) {
        return getEnumerable().orderByDescending(keySelector);
    }

    public Enumerable<T> reverse() {
        return getEnumerable().reverse();
    }

    public <R> Enumerable<R> select(Func<T, R> selector) {
        return getEnumerable().select(selector);
    }

    public <R> Enumerable<R> select(Func2<T, Integer, R> selector) {
        return getEnumerable().select(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func<T, Enumerable<C>> collectionSelector,
            Func2<T, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(Func<T, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func2<T, Integer, Enumerable<C>> collectionSelector,
            Func2<T, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(
            Func2<T, Integer, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public Boolean sequenceEqual(Enumerable<T> second) {
        return getEnumerable().sequenceEqual(second);
    }

    public T single() {
        return getEnumerable().single();
    }

    public T single(Func<T, Boolean> predicate) {
        return getEnumerable().single(predicate);
    }

    public T singleOrDefault() {
        return getEnumerable().singleOrDefault();
    }

    public T singleOrDefault(Func<T, Boolean> predicate, T defaultValue) {
        return getEnumerable().singleOrDefault(predicate, defaultValue);
    }

    public T singleOrDefault(Func<T, Boolean> predicate) {
        return getEnumerable().singleOrDefault(predicate);
    }

    public T singleOrDefault(T defaultValue) {
        return getEnumerable().singleOrDefault(defaultValue);
    }

    public Enumerable<T> skip(int count) {
        return getEnumerable().skip(count);
    }

    public Enumerable<T> skipWhile(Func<T, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public Enumerable<T> skipWhile(Func2<T, Integer, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public int sum() {
        return getEnumerable().sum();
    }

    public int sum(Func<T, Integer> selector) {
        return getEnumerable().sum(selector);
    }

    public double sumDouble() {
        return getEnumerable().sumDouble();
    }

    public double sumDouble(Func<T, Double> selector) {
        return getEnumerable().sumDouble(selector);
    }

    public float sumFloat() {
        return getEnumerable().sumFloat();
    }

    public float sumFloat(Func<T, Float> selector) {
        return getEnumerable().sumFloat(selector);
    }

    public long sumLong() {
        return getEnumerable().sumLong();
    }

    public long sumLong(Func<T, Long> selector) {
        return getEnumerable().sumLong(selector);
    }

    public Enumerable<T> take(int count) {
        return getEnumerable().take(count);
    }

    public Enumerable<T> takeWhile(Func<T, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public Enumerable<T> takeWhile(Func2<T, Integer, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public <R> R[] toArray(Class<R> resultClass) {
        return getEnumerable().toArray(resultClass);
    }

    public <K, E> Dictionary<K, E> toDictionary(Func<T, K> keySelector,
            Func<T, E> elementSelector) {
        return getEnumerable().toDictionary(keySelector, elementSelector);
    }

    public <K> Dictionary<K, T> toDictionary(Func<T, K> keySelector) {
        return getEnumerable().toDictionary(keySelector);
    }

    public List<T> toList() {
        return getEnumerable().toList();
    }

    public EnumerableList<T> toEnumerableList() {
        return getEnumerable().toEnumerableList();
    }

    public <K> Map<K, List<T>> toListMap(Func<T, K> keySelector) {
        return getEnumerable().toListMap(keySelector);
    }

    public <K, E> Map<K, List<E>> toListMap(Func<T, K> keySelector,
            Func<T, E> elementSelector) {
        return getEnumerable().toListMap(keySelector, elementSelector);
    }

    public <K, E> Lookup<K, E> toLookup(Func<T, K> keySelector,
            Func<T, E> elementSelector) {
        return getEnumerable().toLookup(keySelector, elementSelector);
    }

    public <K> Lookup<K, T> toLookup(Func<T, K> keySelector) {
        return getEnumerable().toLookup(keySelector);
    }

    public Enumerable<T> union(Enumerable<T> second) {
        return getEnumerable().union(second);
    }

    public Enumerable<T> where(Func<T, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }

    public Enumerable<T> where(Func2<T, Integer, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }

    public <K> Map<K, T> toMap(Func<T, K> keySelector) {
        return getEnumerable().toMap(keySelector);
    }

    public <K, E> Map<K, E> toMap(Func<T, K> keySelector,
            Func<T, E> elementSelector) {
        return getEnumerable().toMap(keySelector, elementSelector);
    }
}
