package sharin.unlinq;

import java.util.Comparator;
import java.util.List;
import java.util.Map;

public interface Enumerable<T> extends Iterable<T> {

    public T aggregate(Func2<T, T, T> func);

    public <A> A aggregate(A seed, Func2<A, T, A> func);

    public <A, R> R aggregate(A seed, Func2<A, T, A> func,
            Func<A, R> resultSelector);

    public Boolean all(Func<T, Boolean> predicate);

    public Boolean any();

    public Boolean any(Func<T, Boolean> predicate);

    public double average();

    public double averageLong();

    public float averageFloat();

    public double averageDouble();

    public double average(Func<T, Integer> selector);

    public double averageLong(Func<T, Long> selector);

    public float averageFloat(Func<T, Float> selector);

    public double averageDouble(Func<T, Double> selector);

    public <R> Enumerable<R> cast(Class<R> resultClass);

    public Enumerable<T> concat(Enumerable<T> second);

    public boolean contains(Object o);

    public int count();

    public int count(Func<T, Boolean> predicate);

    public Enumerable<T> defaultIfEmpty();

    public Enumerable<T> defaultIfEmpty(T defaultValue);

    public Enumerable<T> distinct();

    public T elementAt(int index);

    public T elementAtOrDefault(int index);

    public T elementAtOrDefault(int index, T defaultValue);

    public Enumerable<T> except(Enumerable<T> second);

    public T first();

    public T first(Func<T, Boolean> predicate);

    public T firstOrDefault();

    public T firstOrDefault(T defaultValue);

    public T firstOrDefault(Func<T, Boolean> predicate);

    public T firstOrDefault(Func<T, Boolean> predicate, T defaultValue);

    public <K> Enumerable<Grouping<K, T>> groupBy(Func<T, K> keySelector);

    public <K, R> Enumerable<R> groupBy(Func<T, K> keySelector,
            Func2<K, Enumerable<T>, R> resultSelector);

    public <K, E> Enumerable<Grouping<K, E>> groupBy(Func<T, K> keySelector,
            Func<T, E> elementSelector);

    public <K, E, R> Enumerable<R> groupBy(Func<T, K> keySelector,
            Func<T, E> elementSelector,
            Func2<K, Enumerable<E>, R> resultSelector);

    public <I, K, R> Enumerable<R> groupJoin(Enumerable<I> inner,
            Func<T, K> outerKeySelector, Func<I, K> innerKeySelector,
            Func2<T, Enumerable<I>, R> resultSelector);

    public Enumerable<T> intersect(Enumerable<T> second);

    public <I, K, R> Enumerable<R> join(Enumerable<I> inner,
            Func<T, K> outerKeySelector, Func<I, K> innerKeySelector,
            Func2<T, I, R> resultSelector);

    public T last();

    public T last(Func<T, Boolean> predicate);

    public T lastOrDefault();

    public T lastOrDefault(T defaultValue);

    public T lastOrDefault(Func<T, Boolean> predicate);

    public T lastOrDefault(Func<T, Boolean> predicate, T defaultValue);

    public long longCount();

    public long longCount(Func<T, Boolean> predicate);

    public T max();

    public <R extends Comparable<R>> R max(Func<T, R> selector);

    public T min();

    public <R extends Comparable<R>> R min(Func<T, R> selector);

    public <R> Enumerable<R> ofType(Class<R> resultClass);

    public <K> OrderedEnumerable<T> orderBy(Func<T, K> keySelector);

    public <K> OrderedEnumerable<T> orderBy(Func<T, K> keySelector,
            Comparator<K> comparator);

    public <K> OrderedEnumerable<T> orderByDescending(Func<T, K> keySelector);

    public <K> OrderedEnumerable<T> orderByDescending(Func<T, K> keySelector,
            Comparator<K> comparator);

    public Enumerable<T> reverse();

    public <R> Enumerable<R> select(Func2<T, Integer, R> selector);

    public <R> Enumerable<R> select(Func<T, R> selector);

    public <R> Enumerable<R> selectMany(Func<T, Enumerable<R>> selector);

    public <R> Enumerable<R> selectMany(
            Func2<T, Integer, Enumerable<R>> selector);

    public <C, R> Enumerable<R> selectMany(
            Func<T, Enumerable<C>> collectionSelector,
            Func2<T, C, R> resultSelector);

    public <C, R> Enumerable<R> selectMany(
            Func2<T, Integer, Enumerable<C>> collectionSelector,
            Func2<T, C, R> resultSelector);

    public Boolean sequenceEqual(Enumerable<T> second);

    public T single();

    public T single(Func<T, Boolean> predicate);

    public T singleOrDefault();

    public T singleOrDefault(T defaultValue);

    public T singleOrDefault(Func<T, Boolean> predicate);

    public T singleOrDefault(Func<T, Boolean> predicate, T defaultValue);

    public Enumerable<T> skip(int count);

    public Enumerable<T> skipWhile(Func<T, Boolean> predicate);

    public Enumerable<T> skipWhile(Func2<T, Integer, Boolean> predicate);

    public int sum();

    public long sumLong();

    public float sumFloat();

    public double sumDouble();

    public int sum(Func<T, Integer> selector);

    public long sumLong(Func<T, Long> selector);

    public float sumFloat(Func<T, Float> selector);

    public double sumDouble(Func<T, Double> selector);

    public Enumerable<T> take(int count);

    public Enumerable<T> takeWhile(Func<T, Boolean> predicate);

    public Enumerable<T> takeWhile(Func2<T, Integer, Boolean> predicate);

    public Object[] toArray();

    public <R> R[] toArray(Class<R> resultClass);

    public <K> Map<K, T> toMap(Func<T, K> keySelector);

    public <K, E> Map<K, E> toMap(Func<T, K> keySelector,
            Func<T, E> elementSelector);

    public <K> Dictionary<K, T> toDictionary(Func<T, K> keySelector);

    public <K, E> Dictionary<K, E> toDictionary(Func<T, K> keySelector,
            Func<T, E> elementSelector);

    public List<T> toList();

    public EnumerableList<T> toEnumerableList();

    public <K> Map<K, List<T>> toListMap(Func<T, K> keySelector);

    public <K, E> Map<K, List<E>> toListMap(Func<T, K> keySelector,
            Func<T, E> elementSelector);

    public <K> Lookup<K, T> toLookup(Func<T, K> keySelector);

    public <K, E> Lookup<K, E> toLookup(Func<T, K> keySelector,
            Func<T, E> elementSelector);

    public Enumerable<T> union(Enumerable<T> second);

    public Enumerable<T> where(Func<T, Boolean> predicate);

    public Enumerable<T> where(Func2<T, Integer, Boolean> predicate);
}
