/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import sharin.unlinq.Func;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedIterator<T>
implements Iterator<T> {
    private final List<List<T>> groupList;
    private final Iterator<T> iterator;

    public <K> OrderedIterator(List<List<T>> groupList, Func<T, K> keySelector, Comparator<K> comparator) {
        this.groupList = this.apply(groupList, keySelector, comparator);
        ArrayList<T> list = new ArrayList<T>();
        for (List<T> group : this.groupList) {
            list.addAll(group);
        }
        this.iterator = list.iterator();
    }

    private <K> List<List<T>> apply(List<List<T>> prevGroupList, Func<T, K> keySelector, Comparator<K> comparator) {
        ArrayList<List<T>> currGroupList = new ArrayList<List<T>>();
        for (List<T> prevGroup : prevGroupList) {
            TreeMap<K, ArrayList<T>> map = new TreeMap<K, ArrayList<T>>(comparator);
            for (T source : prevGroup) {
                K key = keySelector.call(source);
                ArrayList<T> currGroup = (ArrayList<T>)map.get(key);
                if (currGroup == null) {
                    currGroup = new ArrayList<T>();
                    map.put(key, currGroup);
                }
                currGroup.add(source);
            }
            currGroupList.addAll(map.values());
        }
        return currGroupList;
    }

    public List<List<T>> getGroupList() {
        return this.groupList;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

