/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.Queue;
import sharin.unlinq.QueuedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfTypeIterable<T, R>
implements Iterable<R> {
    private final Iterable<T> iterable;
    private final Class<R> resultClass;

    public OfTypeIterable(Iterable<T> iterable, Class<R> resultClass) {
        this.iterable = iterable;
        this.resultClass = resultClass;
    }

    @Override
    public Iterator<R> iterator() {
        return new QueuedIterator<T, T, R>(this.iterable.iterator()){

            @Override
            protected void addElement(Queue<T> queue, T t) {
                if (OfTypeIterable.this.resultClass.isInstance(t)) {
                    queue.add(t);
                }
            }

            @Override
            protected R toResult(T e) {
                return OfTypeIterable.this.resultClass.cast(e);
            }
        };
    }
}

