package sharin.sql.generator;

import sharin.sql.Sql;

public interface SqlGenerator {

    public Sql countAll();

    public Sql countByExample(Object example);

    public Sql countByExamples(Object... examples);

    public Sql selectAll(String propExpr, String orderExpr);

    public Sql selectByExample(String propExpr, String orderExpr, Object example);

    public Sql selectByExamples(String propExpr, String orderExpr,
            Object... examples);

    public Sql selectById(String propExpr, Object id);

    public Sql selectByIds(String propExpr, String orderExpr, Object... ids);

    public Sql insert(String propExpr, Object entity);

    public Sql updateAll(String propExpr, Object entity);

    public Sql updateByExample(String propExpr, Object entity, Object example);

    public Sql updateByExamples(String propExpr, Object entity,
            Object... examples);

    public Sql updateById(String propExpr, Object entity, Object id);

    public Sql updateByIds(String propExpr, Object entity, Object... ids);

    public Sql deleteAll();

    public Sql deleteByExample(Object example);

    public Sql deleteByExamples(Object... examples);

    public Sql deleteById(Object id);

    public Sql deleteByIds(Object... ids);
}
