package sharin.unlinq;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class OrderedIterator<T> implements Iterator<T> {

    private final List<List<T>> groupList;

    private final Iterator<T> iterator;

    public <K> OrderedIterator(List<List<T>> groupList, Func<T, K> keySelector,
            Comparator<K> comparator) {

        this.groupList = apply(groupList, keySelector, comparator);
        List<T> list = new ArrayList<T>();

        for (List<T> group : this.groupList) {
            list.addAll(group);
        }

        iterator = list.iterator();
    }

    private <K> List<List<T>> apply(List<List<T>> prevGroupList,
            Func<T, K> keySelector, Comparator<K> comparator) {

        List<List<T>> currGroupList = new ArrayList<List<T>>();

        for (List<T> prevGroup : prevGroupList) {
            Map<K, List<T>> map = new TreeMap<K, List<T>>(comparator);

            for (T source : prevGroup) {
                K key = keySelector.call(source);
                List<T> currGroup = map.get(key);

                if (currGroup == null) {
                    currGroup = new ArrayList<T>();
                    map.put(key, currGroup);
                }

                currGroup.add(source);
            }

            currGroupList.addAll(map.values());
        }

        return currGroupList;
    }

    public List<List<T>> getGroupList() {
        return groupList;
    }

    public boolean hasNext() {
        return iterator.hasNext();
    }

    public T next() {
        return iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}
