package sharin.unlinq.iterable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

import sharin.unlinq.QueuedIterator;

public class IntersectIterable<T> implements Iterable<T> {

    private final Iterable<T> iterable;

    private final Iterable<T> second;

    public IntersectIterable(Iterable<T> iterable, Iterable<T> second) {
        this.iterable = iterable;
        this.second = second;
    }

    public Iterator<T> iterator() {
        return new QueuedIterator<T, T, T>(iterable.iterator()) {

            private final Set<T> firstSet = new HashSet<T>();

            private final Set<T> secondSet = new HashSet<T>();

            {
                for (T t : second) {
                    secondSet.add(t);
                }
            }

            @Override
            protected void addElement(Queue<T> queue, T t) {

                if (secondSet.contains(t) && !firstSet.contains(t)) {
                    queue.add(t);
                    firstSet.add(t);
                }
            }

            @Override
            protected T toResult(T e) {
                return e;
            }
        };
    }
}
