package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.Queue;

import sharin.unlinq.QueuedIterator;

public class OfTypeIterable<T, R> implements Iterable<R> {

    private final Iterable<T> iterable;

    private final Class<R> resultClass;

    public OfTypeIterable(Iterable<T> iterable, Class<R> resultClass) {
        this.iterable = iterable;
        this.resultClass = resultClass;
    }

    public Iterator<R> iterator() {
        return new QueuedIterator<T, T, R>(iterable.iterator()) {

            @Override
            protected void addElement(Queue<T> queue, T t) {

                if (resultClass.isInstance(t)) {
                    queue.add(t);
                }
            }

            @Override
            protected R toResult(T e) {
                return resultClass.cast(e);
            }
        };
    }
}
