package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.Queue;

import sharin.unlinq.Enumerable;
import sharin.unlinq.Func;
import sharin.unlinq.Func2;
import sharin.unlinq.Pair;
import sharin.unlinq.QueuedIterator;

public class SelectManyIterable<T, C, R> implements Iterable<R> {

    private final Iterable<T> iterable;

    private final Func2<T, C, R> resultSelector;

    private final Func<T, Enumerable<C>> collectionSelector;

    public SelectManyIterable(Iterable<T> iterable,
            Func2<T, C, R> resultSelector,
            Func<T, Enumerable<C>> collectionSelector) {

        this.iterable = iterable;
        this.resultSelector = resultSelector;
        this.collectionSelector = collectionSelector;
    }

    public Iterator<R> iterator() {
        return new QueuedIterator<T, Pair<T, C>, R>(iterable.iterator()) {

            @Override
            protected void addElement(Queue<Pair<T, C>> queue, T t) {

                for (C c : collectionSelector.call(t)) {
                    queue.add(new Pair<T, C>(t, c));
                }
            }

            @Override
            protected R toResult(Pair<T, C> e) {
                return resultSelector.call(e.first, e.second);
            }
        };
    }
}
