package sharin.csv.parser;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BasicCsvPullParser implements CsvPullParser {

    private final char separator;

    public BasicCsvPullParser() {
        this(',');
    }

    public BasicCsvPullParser(char separator) {
        this.separator = separator;
    }

    public String[][] parseAll(Reader reader) {
        List<String[]> recordList = new ArrayList<String[]>();

        for (String[] record : parse(reader)) {
            recordList.add(record);
        }

        return recordList.toArray(new String[recordList.size()][]);
    }

    public Iterable<String[]> parse(final Reader reader) {
        return new Iterable<String[]>() {

            public Iterator<String[]> iterator() {
                return new BasicCsvIterator(reader, separator);
            }
        };
    }
}
