package sharin.unlinq.iterable;

import java.util.Iterator;

import sharin.unlinq.Func;

public class SelectIterable<T, R> implements Iterable<R> {

    private final Iterable<T> iterable;

    private final Func<T, R> selector;

    public SelectIterable(Iterable<T> iterable, Func<T, R> selector) {
        this.iterable = iterable;
        this.selector = selector;
    }

    public Iterator<R> iterator() {
        return new Iterator<R>() {

            private final Iterator<T> iterator = iterable.iterator();

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public R next() {
                return selector.call(iterator.next());
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}
