/*
 * Decompiled with CFR 0.152.
 */
package sharin.sql.formatter;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sharin.sql.formatter.BasicResultBuffer;
import sharin.sql.formatter.Direct;
import sharin.util.PropertyUtils;

class BasicFormatCommand {
    private static final Pattern linePattern = Pattern.compile("^(.*)--\\s*([$&#]?)(.*)$");
    private final Type type;
    private final String body;
    private final String expr;
    private final String escapeChars;

    public BasicFormatCommand(String line, String escapeChars) {
        Type type = Type.NOOP;
        String body = null;
        String expr = null;
        Matcher matcher = linePattern.matcher(line);
        if (matcher.matches()) {
            body = matcher.group(1).trim();
            String group2 = matcher.group(2);
            String group3 = matcher.group(3);
            if (group2 != null && group2.length() > 0) {
                String[] typeExpr;
                Type t;
                char ch = group2.charAt(0);
                if (ch == '$') {
                    type = Type.PRINTE;
                    expr = group3.trim();
                } else if (ch == '&') {
                    type = Type.PRINTD;
                    expr = group3.trim();
                } else if (ch == '#' && (t = Type.find((typeExpr = group3.split("\\s", 2))[0])) != null) {
                    type = t;
                    if (typeExpr.length > 1) {
                        expr = typeExpr[1];
                    }
                }
            }
        } else {
            body = line.trim();
        }
        this.type = type;
        this.body = body;
        this.expr = expr;
        this.escapeChars = escapeChars;
    }

    public void execute(Object context, BasicResultBuffer resultBuffer) {
        String line = null;
        Object[] value = null;
        switch (this.type) {
            case PRINTE: {
                value = (Object[])PropertyUtils.getNestedPropertyValue(context, this.expr);
                if (value != null) {
                    resultBuffer.flush();
                }
                if (value == null && !PropertyUtils.hasNestedProperty(context, this.expr)) {
                    line = this.body;
                    break;
                }
                line = this.convertValue(value);
                break;
            }
            case PRINTD: {
                Object token = PropertyUtils.getNestedPropertyValue(context, this.expr);
                if (token != null) {
                    resultBuffer.flush();
                }
                if (token == null && !PropertyUtils.hasNestedProperty(context, this.expr)) {
                    line = this.body;
                    break;
                }
                if (token instanceof Object[]) {
                    Object[] tokens = (Object[])token;
                    Object[] values = new Object[tokens.length];
                    for (int i = 0; i < tokens.length; ++i) {
                        values[i] = new Direct(tokens[i]);
                    }
                    value = values;
                } else {
                    value = new Direct(token);
                }
                line = this.convertValue(value);
                break;
            }
            case BEGIN: {
                resultBuffer.begin();
                resultBuffer.append(this.body);
                break;
            }
            case END: {
                resultBuffer.append(this.body);
                resultBuffer.end();
                break;
            }
            case PREPEND: {
                resultBuffer.prepend(this.body);
                break;
            }
            default: {
                line = this.body;
            }
        }
        if (line != null && line.length() > 0) {
            resultBuffer.append(line);
        }
    }

    private String convertValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return this.convertString((String)value);
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Direct) {
            return value.toString();
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            StringBuilder builder = new StringBuilder();
            int len = values.length;
            if (len > 0) {
                builder.append(this.convertValue(values[0]));
                for (int i = 1; i < len; ++i) {
                    builder.append(", ");
                    builder.append(this.convertValue(values[i]));
                }
            }
            return builder.toString();
        }
        return this.convertString(value.toString());
    }

    private String convertString(String s) {
        StringBuilder builder = new StringBuilder();
        builder.append('\'');
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (this.escapeChars.indexOf(ch) != -1) {
                builder.append(ch);
            }
            builder.append(ch);
        }
        builder.append('\'');
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        NOOP,
        PRINTE,
        PRINTD,
        BEGIN,
        END,
        PREPEND;

        private static final Map<String, Type> nameMap;

        public static Type find(String name) {
            return nameMap.get(name);
        }

        static {
            nameMap = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                nameMap.put(type.name().toLowerCase(), type);
            }
        }
    }
}

