/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import sharin.unlinq.BasicDictionary;
import sharin.unlinq.BasicEnumerableList;
import sharin.unlinq.BasicGrouping;
import sharin.unlinq.BasicLookup;
import sharin.unlinq.BasicOrderedEnumerable;
import sharin.unlinq.Dictionary;
import sharin.unlinq.Enumerable;
import sharin.unlinq.EnumerableList;
import sharin.unlinq.Func;
import sharin.unlinq.Func2;
import sharin.unlinq.Grouping;
import sharin.unlinq.Lookup;
import sharin.unlinq.OrderedEnumerable;
import sharin.unlinq.OrderedIterator;
import sharin.unlinq.iterable.CastIterable;
import sharin.unlinq.iterable.ConcatIterable;
import sharin.unlinq.iterable.DefaultIfEmptyIterable;
import sharin.unlinq.iterable.DistinctIterable;
import sharin.unlinq.iterable.ExceptIterable;
import sharin.unlinq.iterable.GroupJoinIterable;
import sharin.unlinq.iterable.IntersectIterable;
import sharin.unlinq.iterable.JoinIterable;
import sharin.unlinq.iterable.OfTypeIterable;
import sharin.unlinq.iterable.RangeIterable;
import sharin.unlinq.iterable.RepeatIterable;
import sharin.unlinq.iterable.SelectIterable;
import sharin.unlinq.iterable.SelectManyIterable;
import sharin.unlinq.iterable.SkipIterable;
import sharin.unlinq.iterable.SkipWhileIterable;
import sharin.unlinq.iterable.TakeIterable;
import sharin.unlinq.iterable.TakeWhileIterable;
import sharin.unlinq.iterable.UnionIterable;
import sharin.unlinq.iterable.WhereIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEnumerable<TSource>
implements Enumerable<TSource> {
    private final Iterable<TSource> iterable;

    public BasicEnumerable(Iterable<TSource> iterable) {
        if (iterable == null) {
            iterable = Collections.emptyList();
        }
        this.iterable = iterable;
    }

    @Override
    public Iterator<TSource> iterator() {
        return this.iterable.iterator();
    }

    public static <E> Enumerable<E> from(Iterable<E> iterable) {
        return new BasicEnumerable<E>(iterable);
    }

    public static <E> Enumerable<E> from(E ... objects) {
        List<E> iterable = null;
        if (objects != null) {
            iterable = Arrays.asList(objects);
        }
        return BasicEnumerable.from(iterable);
    }

    public static Enumerable<Boolean> fromBoolean(boolean ... values) {
        Boolean[] wrappers = null;
        if (values != null) {
            wrappers = new Boolean[values.length];
            for (int i = 0; i < values.length; ++i) {
                wrappers[i] = values[i];
            }
        }
        return BasicEnumerable.from(wrappers);
    }

    public static Enumerable<Byte> fromByte(byte ... values) {
        Byte[] wrappers = null;
        if (values != null) {
            wrappers = new Byte[values.length];
            for (int i = 0; i < values.length; ++i) {
                wrappers[i] = values[i];
            }
        }
        return BasicEnumerable.from(wrappers);
    }

    public static Enumerable<Character> fromChar(char ... values) {
        Character[] wrappers = null;
        if (values != null) {
            wrappers = new Character[values.length];
            for (int i = 0; i < values.length; ++i) {
                wrappers[i] = Character.valueOf(values[i]);
            }
        }
        return BasicEnumerable.from(wrappers);
    }

    public static Enumerable<Short> fromShort(short ... values) {
        Short[] wrappers = null;
        if (values != null) {
            wrappers = new Short[values.length];
            for (int i = 0; i < values.length; ++i) {
                wrappers[i] = values[i];
            }
        }
        return BasicEnumerable.from(wrappers);
    }

    public static Enumerable<Integer> from(int ... values) {
        Integer[] wrappers = null;
        if (values != null) {
            wrappers = new Integer[values.length];
            for (int i = 0; i < values.length; ++i) {
                wrappers[i] = values[i];
            }
        }
        return BasicEnumerable.from(wrappers);
    }

    public static Enumerable<Long> fromLong(long ... values) {
        Long[] wrappers = null;
        if (values != null) {
            wrappers = new Long[values.length];
            for (int i = 0; i < values.length; ++i) {
                wrappers[i] = values[i];
            }
        }
        return BasicEnumerable.from(wrappers);
    }

    public static Enumerable<Float> fromFloat(float ... values) {
        Float[] wrappers = null;
        if (values != null) {
            wrappers = new Float[values.length];
            for (int i = 0; i < values.length; ++i) {
                wrappers[i] = Float.valueOf(values[i]);
            }
        }
        return BasicEnumerable.from(wrappers);
    }

    public static Enumerable<Double> fromDouble(double ... values) {
        Double[] wrappers = null;
        if (values != null) {
            wrappers = new Double[values.length];
            for (int i = 0; i < values.length; ++i) {
                wrappers[i] = values[i];
            }
        }
        return BasicEnumerable.from(wrappers);
    }

    @Override
    public TSource aggregate(Func2<TSource, TSource, TSource> func) {
        Iterator<TSource> iterator = this.iterable.iterator();
        TSource seed = iterator.next();
        return this.doAggregate(seed, func, iterator);
    }

    @Override
    public <A> A aggregate(A seed, Func2<A, TSource, A> func) {
        return this.doAggregate(seed, func, this.iterable.iterator());
    }

    @Override
    public <A, R> R aggregate(A seed, Func2<A, TSource, A> func, Func<A, R> resultSelector) {
        A a = this.doAggregate(seed, func, this.iterable.iterator());
        return resultSelector.call(a);
    }

    private <A> A doAggregate(A seed, Func2<A, TSource, A> func, Iterator<TSource> iterator) {
        A a = seed;
        while (iterator.hasNext()) {
            a = func.call(a, iterator.next());
        }
        return a;
    }

    @Override
    public Boolean all(Func<TSource, Boolean> predicate) {
        for (TSource source : this.iterable) {
            if (predicate.call(source).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean any() {
        return this.iterable.iterator().hasNext();
    }

    @Override
    public Boolean any(Func<TSource, Boolean> predicate) {
        for (TSource source : this.iterable) {
            if (!predicate.call(source).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumerable<TSource> asEnumerable() {
        return new BasicEnumerable<TSource>(this.iterable);
    }

    @Override
    public double average() {
        Iterator<TSource> iterator = this.iterable.iterator();
        double sum = ((Integer)iterator.next()).intValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += (double)((Integer)iterator.next()).intValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double averageLong() {
        Iterator<TSource> iterator = this.iterable.iterator();
        double sum = ((Long)iterator.next()).longValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += (double)((Long)iterator.next()).longValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public float averageFloat() {
        Iterator<TSource> iterator = this.iterable.iterator();
        float sum = ((Float)iterator.next()).floatValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += ((Float)iterator.next()).floatValue();
            ++count;
        }
        return sum / (float)count;
    }

    @Override
    public double averageDouble() {
        Iterator<TSource> iterator = this.iterable.iterator();
        double sum = (Double)iterator.next();
        int count = 1;
        while (iterator.hasNext()) {
            sum += ((Double)iterator.next()).doubleValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double average(Func<TSource, Integer> selector) {
        Iterator<TSource> iterator = this.iterable.iterator();
        double sum = selector.call(iterator.next()).intValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += (double)selector.call(iterator.next()).intValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public double averageLong(Func<TSource, Long> selector) {
        Iterator<TSource> iterator = this.iterable.iterator();
        double sum = selector.call(iterator.next()).longValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += (double)selector.call(iterator.next()).longValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public float averageFloat(Func<TSource, Float> selector) {
        Iterator<TSource> iterator = this.iterable.iterator();
        float sum = selector.call(iterator.next()).floatValue();
        int count = 1;
        while (iterator.hasNext()) {
            sum += selector.call(iterator.next()).floatValue();
            ++count;
        }
        return sum / (float)count;
    }

    @Override
    public double averageDouble(Func<TSource, Double> selector) {
        Iterator<TSource> iterator = this.iterable.iterator();
        double sum = selector.call(iterator.next());
        int count = 1;
        while (iterator.hasNext()) {
            sum += selector.call(iterator.next()).doubleValue();
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public <R> Enumerable<R> cast(Class<R> resultClass) {
        return new BasicEnumerable<TSource>(new CastIterable<TSource, R>(this.iterable, resultClass));
    }

    @Override
    public Enumerable<TSource> concat(Enumerable<TSource> second) {
        return new BasicEnumerable<TSource>(new ConcatIterable<TSource>(this.iterable, second));
    }

    @Override
    public boolean contains(Object o) {
        for (TSource source : this.iterable) {
            if (!this.equals(o, source)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int count() {
        int c = 0;
        Iterator<TSource> it = this.iterable.iterator();
        while (it.hasNext()) {
            ++c;
            it.next();
        }
        return c;
    }

    @Override
    public int count(Func<TSource, Boolean> predicate) {
        int c = 0;
        for (TSource source : this.iterable) {
            if (!predicate.call(source).booleanValue()) continue;
            ++c;
        }
        return c;
    }

    @Override
    public Enumerable<TSource> defaultIfEmpty() {
        return this.defaultIfEmpty(null);
    }

    @Override
    public Enumerable<TSource> defaultIfEmpty(TSource defaultValue) {
        return new BasicEnumerable<TSource>(new DefaultIfEmptyIterable<TSource>(this.iterable, defaultValue));
    }

    @Override
    public Enumerable<TSource> distinct() {
        return new BasicEnumerable<TSource>(new DistinctIterable<TSource>(this.iterable));
    }

    @Override
    public TSource elementAt(int index) {
        Iterator<TSource> iterator = this.iterable.iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    @Override
    public TSource elementAtOrDefault(int index) {
        return this.elementAtOrDefault(index, null);
    }

    @Override
    public TSource elementAtOrDefault(int index, TSource defaultValue) {
        Iterator<TSource> iterator = this.iterable.iterator();
        for (int i = 0; i < index; ++i) {
            if (!iterator.hasNext()) {
                return defaultValue;
            }
            iterator.next();
        }
        if (!iterator.hasNext()) {
            return defaultValue;
        }
        return iterator.next();
    }

    public static <R> Enumerable<R> empty() {
        return new BasicEnumerable(null);
    }

    @Override
    public Enumerable<TSource> except(Enumerable<TSource> second) {
        return new BasicEnumerable<TSource>(new ExceptIterable<TSource>(this.iterable, second));
    }

    @Override
    public TSource first() {
        return this.iterable.iterator().next();
    }

    @Override
    public TSource first(Func<TSource, Boolean> predicate) {
        for (TSource source : this.iterable) {
            if (!predicate.call(source).booleanValue()) continue;
            return source;
        }
        throw new NoSuchElementException();
    }

    @Override
    public TSource firstOrDefault() {
        return (TSource)this.firstOrDefault((Object)null);
    }

    @Override
    public TSource firstOrDefault(TSource defaultValue) {
        Iterator<TSource> iterator = this.iterable.iterator();
        if (!iterator.hasNext()) {
            return defaultValue;
        }
        return iterator.next();
    }

    @Override
    public TSource firstOrDefault(Func<TSource, Boolean> predicate) {
        return this.firstOrDefault(predicate, null);
    }

    @Override
    public TSource firstOrDefault(Func<TSource, Boolean> predicate, TSource defaultValue) {
        for (TSource source : this.iterable) {
            if (!predicate.call(source).booleanValue()) continue;
            return source;
        }
        return defaultValue;
    }

    @Override
    public <K> Enumerable<Grouping<K, TSource>> groupBy(Func<TSource, K> keySelector) {
        return this.groupBy(keySelector, this.getPassThroughFunc());
    }

    @Override
    public <K, E> Enumerable<Grouping<K, E>> groupBy(Func<TSource, K> keySelector, Func<TSource, E> elementSelector) {
        return this.groupBy(keySelector, elementSelector, new Func2<K, Enumerable<E>, Grouping<K, E>>(){

            @Override
            public Grouping<K, E> call(K arg1, Enumerable<E> arg2) {
                return new BasicGrouping(arg1, arg2);
            }
        });
    }

    @Override
    public <K, R> Enumerable<R> groupBy(Func<TSource, K> keySelector, Func2<K, Enumerable<TSource>, R> resultSelector) {
        return this.groupBy(keySelector, this.getPassThroughFunc(), resultSelector);
    }

    @Override
    public <K, E, R> Enumerable<R> groupBy(final Func<TSource, K> keySelector, final Func<TSource, E> elementSelector, final Func2<K, Enumerable<E>, R> resultSelector) {
        return new BasicEnumerable<TSource>(new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                LinkedHashMap map = new LinkedHashMap();
                for (Object source : BasicEnumerable.this.iterable) {
                    Object key = keySelector.call(source);
                    ArrayList list = (ArrayList)map.get(key);
                    if (list == null) {
                        list = new ArrayList();
                        map.put(key, list);
                    }
                    list.add(elementSelector.call(source));
                }
                ArrayList resultList = new ArrayList();
                for (Map.Entry entry : map.entrySet()) {
                    resultList.add(resultSelector.call(entry.getKey(), new BasicEnumerable((Iterable)entry.getValue())));
                }
                return resultList.iterator();
            }
        });
    }

    @Override
    public <I, K, R> Enumerable<R> groupJoin(Enumerable<I> inner, Func<TSource, K> outerKeySelector, Func<I, K> innerKeySelector, Func2<TSource, Enumerable<I>, R> resultSelector) {
        return new BasicEnumerable<TSource>(new GroupJoinIterable<TSource, I, K, R>(this.iterable, inner, outerKeySelector, innerKeySelector, resultSelector));
    }

    @Override
    public Enumerable<TSource> intersect(Enumerable<TSource> second) {
        return new BasicEnumerable<TSource>(new IntersectIterable<TSource>(this.iterable, second));
    }

    @Override
    public <I, K, R> Enumerable<R> join(Enumerable<I> inner, Func<TSource, K> outerKeySelector, Func<I, K> innerKeySelector, Func2<TSource, I, R> resultSelector) {
        return new BasicEnumerable<TSource>(new JoinIterable<TSource, I, K, R>(this.iterable, inner, outerKeySelector, innerKeySelector, resultSelector));
    }

    @Override
    public TSource last() {
        Iterator<TSource> iterator = this.iterable.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        TSource last = null;
        while (iterator.hasNext()) {
            last = iterator.next();
        }
        return last;
    }

    @Override
    public TSource last(Func<TSource, Boolean> predicate) {
        TSource last = null;
        boolean found = false;
        for (TSource source : this.iterable) {
            if (!predicate.call(source).booleanValue()) continue;
            last = source;
            if (found) continue;
            found = true;
        }
        if (!found) {
            throw new NoSuchElementException();
        }
        return last;
    }

    @Override
    public TSource lastOrDefault() {
        return (TSource)this.lastOrDefault((Object)null);
    }

    @Override
    public TSource lastOrDefault(TSource defaultValue) {
        Iterator<TSource> iterator = this.iterable.iterator();
        if (!iterator.hasNext()) {
            return defaultValue;
        }
        TSource last = null;
        while (iterator.hasNext()) {
            last = iterator.next();
        }
        return last;
    }

    @Override
    public TSource lastOrDefault(Func<TSource, Boolean> predicate) {
        return this.lastOrDefault(predicate, null);
    }

    @Override
    public TSource lastOrDefault(Func<TSource, Boolean> predicate, TSource defaultValue) {
        TSource last = null;
        boolean found = false;
        for (TSource source : this.iterable) {
            if (!predicate.call(source).booleanValue()) continue;
            last = source;
            if (found) continue;
            found = true;
        }
        if (!found) {
            return defaultValue;
        }
        return last;
    }

    @Override
    public long longCount() {
        long c = 0L;
        Iterator<TSource> it = this.iterable.iterator();
        while (it.hasNext()) {
            ++c;
            it.next();
        }
        return c;
    }

    @Override
    public long longCount(Func<TSource, Boolean> predicate) {
        long c = 0L;
        for (TSource source : this.iterable) {
            if (!predicate.call(source).booleanValue()) continue;
            ++c;
        }
        return c;
    }

    @Override
    public TSource max() {
        Iterator<TSource> iterator = this.iterable.iterator();
        TSource max = iterator.next();
        while (iterator.hasNext()) {
            TSource source = iterator.next();
            if (((Comparable)source).compareTo(max) <= 0) continue;
            max = source;
        }
        return max;
    }

    @Override
    public <R extends Comparable<R>> R max(Func<TSource, R> selector) {
        Iterator<TSource> iterator = this.iterable.iterator();
        Comparable max = (Comparable)selector.call(iterator.next());
        while (iterator.hasNext()) {
            Comparable r = (Comparable)selector.call(iterator.next());
            if (r.compareTo(max) <= 0) continue;
            max = r;
        }
        return (R)max;
    }

    @Override
    public TSource min() {
        Iterator<TSource> iterator = this.iterable.iterator();
        TSource min = iterator.next();
        while (iterator.hasNext()) {
            TSource source = iterator.next();
            if (((Comparable)source).compareTo(min) >= 0) continue;
            min = source;
        }
        return min;
    }

    @Override
    public <R extends Comparable<R>> R min(Func<TSource, R> selector) {
        Iterator<TSource> iterator = this.iterable.iterator();
        Comparable min = (Comparable)selector.call(iterator.next());
        while (iterator.hasNext()) {
            Comparable r = (Comparable)selector.call(iterator.next());
            if (r.compareTo(min) >= 0) continue;
            min = r;
        }
        return (R)min;
    }

    @Override
    public <R> Enumerable<R> ofType(Class<R> resultClass) {
        return new BasicEnumerable<TSource>(new OfTypeIterable<TSource, R>(this.iterable, resultClass));
    }

    @Override
    public <K> OrderedEnumerable<TSource> orderBy(Func<TSource, K> keySelector) {
        return this.orderBy(keySelector, null);
    }

    @Override
    public <K> OrderedEnumerable<TSource> orderBy(final Func<TSource, K> keySelector, final Comparator<K> comparator) {
        return new BasicOrderedEnumerable(new Iterable<TSource>(){

            @Override
            public Iterator<TSource> iterator() {
                ArrayList groupList = new ArrayList();
                groupList.add(BasicEnumerable.this.toList());
                return new OrderedIterator(groupList, keySelector, comparator);
            }
        });
    }

    @Override
    public <K> OrderedEnumerable<TSource> orderByDescending(Func<TSource, K> keySelector) {
        return this.orderBy(keySelector, Collections.reverseOrder(null));
    }

    @Override
    public <K> OrderedEnumerable<TSource> orderByDescending(Func<TSource, K> keySelector, Comparator<K> comparator) {
        return this.orderBy(keySelector, Collections.reverseOrder(comparator));
    }

    public static Enumerable<Integer> range(int start, int count) {
        return new BasicEnumerable<Integer>(new RangeIterable(start, count));
    }

    public static <R> Enumerable<R> repeat(R element, int count) {
        return new BasicEnumerable<R>(new RepeatIterable<R>(count, element));
    }

    @Override
    public Enumerable<TSource> reverse() {
        return new BasicEnumerable<TSource>(new Iterable<TSource>(){

            @Override
            public Iterator<TSource> iterator() {
                List list = BasicEnumerable.this.toList();
                Collections.reverse(list);
                return list.iterator();
            }
        });
    }

    @Override
    public <R> Enumerable<R> select(Func<TSource, R> selector) {
        return new BasicEnumerable<TSource>(new SelectIterable<TSource, R>(this.iterable, selector));
    }

    @Override
    public <R> Enumerable<R> select(final Func2<TSource, Integer, R> selector) {
        return this.select(new Func<TSource, R>(){
            private int index;

            @Override
            public R call(TSource arg1) {
                return selector.call(arg1, this.index++);
            }
        });
    }

    @Override
    public <R> Enumerable<R> selectMany(Func<TSource, Enumerable<R>> selector) {
        return this.selectMany(selector, new Func2<TSource, R, R>(){

            @Override
            public R call(TSource arg1, R arg2) {
                return arg2;
            }
        });
    }

    @Override
    public <R> Enumerable<R> selectMany(final Func2<TSource, Integer, Enumerable<R>> selector) {
        return this.selectMany(new Func<TSource, Enumerable<R>>(){
            private int index;

            @Override
            public Enumerable<R> call(TSource arg1) {
                return (Enumerable)selector.call(arg1, this.index++);
            }
        });
    }

    @Override
    public <C, R> Enumerable<R> selectMany(Func<TSource, Enumerable<C>> collectionSelector, Func2<TSource, C, R> resultSelector) {
        return new BasicEnumerable<TSource>(new SelectManyIterable<TSource, C, R>(this.iterable, resultSelector, collectionSelector));
    }

    @Override
    public <C, R> Enumerable<R> selectMany(final Func2<TSource, Integer, Enumerable<C>> collectionSelector, Func2<TSource, C, R> resultSelector) {
        return this.selectMany(new Func<TSource, Enumerable<C>>(){
            private int index;

            @Override
            public Enumerable<C> call(TSource arg1) {
                return (Enumerable)collectionSelector.call(arg1, this.index++);
            }
        }, resultSelector);
    }

    @Override
    public Boolean sequenceEqual(Enumerable<TSource> second) {
        Iterator iterator = second.iterator();
        for (TSource f : this.iterable) {
            if (!iterator.hasNext()) {
                return false;
            }
            if (this.equals(f, iterator.next())) continue;
            return false;
        }
        if (iterator.hasNext()) {
            return false;
        }
        return true;
    }

    @Override
    public TSource single() {
        Iterator<TSource> iterator = this.iterable.iterator();
        TSource source = iterator.next();
        if (iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        return source;
    }

    @Override
    public TSource single(Func<TSource, Boolean> predicate) {
        TSource single = null;
        boolean found = false;
        for (TSource source : this.iterable) {
            if (!predicate.call(source).booleanValue()) continue;
            if (found) {
                found = false;
                break;
            }
            single = source;
            found = true;
        }
        if (!found) {
            throw new NoSuchElementException();
        }
        return single;
    }

    @Override
    public TSource singleOrDefault() {
        return (TSource)this.singleOrDefault((Object)null);
    }

    @Override
    public TSource singleOrDefault(TSource defaultValue) {
        Iterator<TSource> iterator = this.iterable.iterator();
        if (!iterator.hasNext()) {
            return defaultValue;
        }
        TSource source = iterator.next();
        if (iterator.hasNext()) {
            return defaultValue;
        }
        return source;
    }

    @Override
    public TSource singleOrDefault(Func<TSource, Boolean> predicate) {
        return (TSource)this.singleOrDefault(predicate, null);
    }

    @Override
    public TSource singleOrDefault(Func<TSource, Boolean> predicate, TSource defaultValue) {
        TSource single = null;
        boolean found = false;
        for (TSource source : this.iterable) {
            if (!predicate.call(source).booleanValue()) continue;
            if (found) {
                found = false;
                break;
            }
            single = source;
            found = true;
        }
        if (!found) {
            return defaultValue;
        }
        return single;
    }

    @Override
    public Enumerable<TSource> skip(int count) {
        return new BasicEnumerable<TSource>(new SkipIterable<TSource>(this.iterable, count));
    }

    @Override
    public Enumerable<TSource> skipWhile(Func<TSource, Boolean> predicate) {
        return new BasicEnumerable<TSource>(new SkipWhileIterable<TSource>(this.iterable, predicate));
    }

    @Override
    public Enumerable<TSource> skipWhile(final Func2<TSource, Integer, Boolean> predicate) {
        return this.skipWhile(new Func<TSource, Boolean>(){
            private int index;

            @Override
            public Boolean call(TSource arg1) {
                return (Boolean)predicate.call(arg1, this.index++);
            }
        });
    }

    @Override
    public int sum() {
        int sum = 0;
        for (TSource source : this.iterable) {
            sum += ((Integer)source).intValue();
        }
        return sum;
    }

    @Override
    public long sumLong() {
        long sum = 0L;
        for (TSource source : this.iterable) {
            sum += ((Long)source).longValue();
        }
        return sum;
    }

    @Override
    public float sumFloat() {
        float sum = 0.0f;
        for (TSource source : this.iterable) {
            sum += ((Float)source).floatValue();
        }
        return sum;
    }

    @Override
    public double sumDouble() {
        double sum = 0.0;
        for (TSource source : this.iterable) {
            sum += ((Double)source).doubleValue();
        }
        return sum;
    }

    @Override
    public int sum(Func<TSource, Integer> selector) {
        int sum = 0;
        for (TSource source : this.iterable) {
            sum += selector.call(source).intValue();
        }
        return sum;
    }

    @Override
    public long sumLong(Func<TSource, Long> selector) {
        long sum = 0L;
        for (TSource source : this.iterable) {
            sum += selector.call(source).longValue();
        }
        return sum;
    }

    @Override
    public float sumFloat(Func<TSource, Float> selector) {
        float sum = 0.0f;
        for (TSource source : this.iterable) {
            sum += selector.call(source).floatValue();
        }
        return sum;
    }

    @Override
    public double sumDouble(Func<TSource, Double> selector) {
        double sum = 0.0;
        for (TSource source : this.iterable) {
            sum += selector.call(source).doubleValue();
        }
        return sum;
    }

    @Override
    public Enumerable<TSource> take(int count) {
        return new BasicEnumerable<TSource>(new TakeIterable<TSource>(this.iterable, count));
    }

    @Override
    public Enumerable<TSource> takeWhile(Func<TSource, Boolean> predicate) {
        return new BasicEnumerable<TSource>(new TakeWhileIterable<TSource>(this.iterable, predicate));
    }

    @Override
    public Enumerable<TSource> takeWhile(final Func2<TSource, Integer, Boolean> predicate) {
        return this.takeWhile(new Func<TSource, Boolean>(){
            private int index;

            @Override
            public Boolean call(TSource arg1) {
                return (Boolean)predicate.call(arg1, this.index++);
            }
        });
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <R> R[] toArray(Class<R> resultClass) {
        List<TSource> list = this.toList();
        Object[] array = (Object[])Array.newInstance(resultClass, list.size());
        return list.toArray(array);
    }

    @Override
    public List<TSource> toList() {
        ArrayList<TSource> list = new ArrayList<TSource>();
        for (TSource e : this.iterable) {
            list.add(e);
        }
        return list;
    }

    @Override
    public EnumerableList<TSource> toEnumerableList() {
        return new BasicEnumerableList<TSource>(this.toList());
    }

    @Override
    public <K> Map<K, List<TSource>> toListMap(Func<TSource, K> keySelector) {
        return this.toListMap(keySelector, this.getPassThroughFunc());
    }

    @Override
    public <K, E> Map<K, List<E>> toListMap(Func<TSource, K> keySelector, Func<TSource, E> elementSelector) {
        LinkedHashMap<K, ArrayList<E>> map = new LinkedHashMap<K, ArrayList<E>>();
        for (TSource source : this.iterable) {
            K k = keySelector.call(source);
            ArrayList<E> list = (ArrayList<E>)map.get(k);
            if (list == null) {
                list = new ArrayList<E>();
                map.put(k, list);
            }
            list.add(elementSelector.call(source));
        }
        return map;
    }

    @Override
    public <K> Lookup<K, TSource> toLookup(Func<TSource, K> keySelector) {
        return this.toLookup(keySelector, this.getPassThroughFunc());
    }

    @Override
    public <K, E> Lookup<K, E> toLookup(Func<TSource, K> keySelector, Func<TSource, E> elementSelector) {
        return new BasicLookup<K, E>(this.toListMap(keySelector, elementSelector));
    }

    @Override
    public <K> Map<K, TSource> toMap(Func<TSource, K> keySelector) {
        return this.toMap(keySelector, this.getPassThroughFunc());
    }

    @Override
    public <K, E> Map<K, E> toMap(Func<TSource, K> keySelector, Func<TSource, E> elementSelector) {
        LinkedHashMap<K, E> map = new LinkedHashMap<K, E>();
        for (TSource source : this.iterable) {
            K k = keySelector.call(source);
            if (map.containsKey(k)) {
                throw new IllegalArgumentException();
            }
            map.put(k, elementSelector.call(source));
        }
        return map;
    }

    @Override
    public <K> Dictionary<K, TSource> toDictionary(Func<TSource, K> keySelector) {
        return this.toDictionary(keySelector, this.getPassThroughFunc());
    }

    @Override
    public <K, E> Dictionary<K, E> toDictionary(Func<TSource, K> keySelector, Func<TSource, E> elementSelector) {
        return new BasicDictionary<K, E>(this.toMap(keySelector, elementSelector));
    }

    @Override
    public Enumerable<TSource> union(Enumerable<TSource> second) {
        return new BasicEnumerable<TSource>(new UnionIterable<TSource>(this.iterable, second));
    }

    @Override
    public Enumerable<TSource> where(Func<TSource, Boolean> predicate) {
        return new BasicEnumerable<TSource>(new WhereIterable<TSource>(this.iterable, predicate));
    }

    @Override
    public Enumerable<TSource> where(final Func2<TSource, Integer, Boolean> predicate) {
        return this.where(new Func<TSource, Boolean>(){
            private int index;

            @Override
            public Boolean call(TSource arg1) {
                return (Boolean)predicate.call(arg1, this.index++);
            }
        });
    }

    private boolean equals(Object o1, Object o2) {
        return o2 == null ? o1 == null : o2.equals(o1);
    }

    private Func<TSource, TSource> getPassThroughFunc() {
        return new Func<TSource, TSource>(){

            @Override
            public TSource call(TSource arg1) {
                return arg1;
            }
        };
    }
}

