/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq.iterable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sharin.unlinq.BasicEnumerable;
import sharin.unlinq.Enumerable;
import sharin.unlinq.Func;
import sharin.unlinq.Func2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupJoinIterable<O, I, K, R>
implements Iterable<R> {
    private final Iterable<O> outer;
    private final Iterable<I> inner;
    private final Func<O, K> outerKeySelector;
    private final Func<I, K> innerKeySelector;
    private final Func2<O, Enumerable<I>, R> resultSelector;

    public GroupJoinIterable(Iterable<O> outer, Iterable<I> inner, Func<O, K> outerKeySelector, Func<I, K> innerKeySelector, Func2<O, Enumerable<I>, R> resultSelector) {
        this.outer = outer;
        this.resultSelector = resultSelector;
        this.innerKeySelector = innerKeySelector;
        this.outerKeySelector = outerKeySelector;
        this.inner = inner;
    }

    @Override
    public Iterator<R> iterator() {
        return new Iterator<R>(){
            private final Iterator<O> iterator;
            private final Map<K, List<I>> innerListMap;
            {
                this.iterator = GroupJoinIterable.this.outer.iterator();
                this.innerListMap = new HashMap();
                for (Object i : GroupJoinIterable.this.inner) {
                    Object innerKey = GroupJoinIterable.this.innerKeySelector.call(i);
                    List innerList = this.innerListMap.get(innerKey);
                    if (innerList == null) {
                        innerList = new ArrayList();
                        this.innerListMap.put(innerKey, innerList);
                    }
                    innerList.add(i);
                }
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public R next() {
                Object o = this.iterator.next();
                Object outerKey = GroupJoinIterable.this.outerKeySelector.call(o);
                List innerList = this.innerListMap.get(outerKey);
                return GroupJoinIterable.this.resultSelector.call(o, new BasicEnumerable(innerList));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

