/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq.iterable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import sharin.unlinq.Func;
import sharin.unlinq.Func2;
import sharin.unlinq.Pair;
import sharin.unlinq.QueuedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinIterable<O, I, K, R>
implements Iterable<R> {
    private final Iterable<O> outer;
    private final Iterable<I> inner;
    private final Func<O, K> outerKeySelector;
    private final Func<I, K> innerKeySelector;
    private final Func2<O, I, R> resultSelector;

    public JoinIterable(Iterable<O> outer, Iterable<I> inner, Func<O, K> outerKeySelector, Func<I, K> innerKeySelector, Func2<O, I, R> resultSelector) {
        this.outer = outer;
        this.resultSelector = resultSelector;
        this.innerKeySelector = innerKeySelector;
        this.outerKeySelector = outerKeySelector;
        this.inner = inner;
    }

    @Override
    public Iterator<R> iterator() {
        return new QueuedIterator<O, Pair<O, I>, R>(this.outer.iterator()){
            private final Map<K, I> innerMap;
            {
                this.innerMap = new HashMap();
                for (Object i : JoinIterable.this.inner) {
                    Object innerKey = JoinIterable.this.innerKeySelector.call(i);
                    this.innerMap.put(innerKey, i);
                }
            }

            @Override
            protected void addElement(Queue<Pair<O, I>> queue, O t) {
                Object outerKey = JoinIterable.this.outerKeySelector.call(t);
                Object i = this.innerMap.get(outerKey);
                if (i != null) {
                    queue.add(new Pair(t, i));
                }
            }

            @Override
            protected R toResult(Pair<O, I> e) {
                return JoinIterable.this.resultSelector.call(e.first, e.second);
            }
        };
    }
}

