/*
 * Decompiled with CFR 0.152.
 */
package sharin.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class StringUtils {
    public static String decodeUrl(String s, String enc) {
        try {
            return URLDecoder.decode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeUrl(String s, String enc) {
        try {
            return URLEncoder.encode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String escapeXml(String s) {
        return StringUtils.appendXml(new StringBuilder(), s).toString();
    }

    public static StringBuilder appendXml(StringBuilder builder, String s) {
        block7: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    builder.append("&quot;");
                    continue block7;
                }
                case '&': {
                    builder.append("&amp;");
                    continue block7;
                }
                case '<': {
                    builder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    builder.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    builder.append("&apos;");
                    continue block7;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        return builder;
    }

    public static String escapeCsv(String s) {
        return StringUtils.appendCsv(new StringBuilder(), s, ',').toString();
    }

    public static String escapeTsv(String s) {
        return StringUtils.appendCsv(new StringBuilder(), s, '\t').toString();
    }

    public static String escapeCsv(String s, char separator) {
        return StringUtils.appendCsv(new StringBuilder(), s, separator).toString();
    }

    public static StringBuilder appendCsv(StringBuilder builder, String s) {
        return StringUtils.appendCsv(builder, s, ',');
    }

    public static StringBuilder appendTsv(StringBuilder builder, String s) {
        return StringUtils.appendCsv(builder, s, '\t');
    }

    public static StringBuilder appendCsv(StringBuilder builder, String s, char separator) {
        int index = s.indexOf(34);
        if (index == -1) {
            boolean found = false;
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch != separator && ch != '\r' && ch != '\n') continue;
                found = true;
                break;
            }
            if (!found) {
                return builder.append(s);
            }
        }
        builder.append('\"');
        int i = 0;
        while (index != -1) {
            builder.append(s.substring(i, index + 1));
            builder.append('\"');
            i = index + 1;
            index = s.indexOf(34, i);
        }
        if (i < s.length()) {
            builder.append(s.substring(i, s.length()));
        }
        return builder.append('\"');
    }
}

