package sharin.sql.runner.converter;

import java.sql.ResultSet;

import sharin.sql.runner.ColumnConverter;
import sharin.util.SqlUtils;

public class FloatColumnConverter implements ColumnConverter {

    public Object convert(ResultSet rs, int columnIndex) {
        float value = SqlUtils.getFloat(rs, columnIndex);

        if (value == 0 && SqlUtils.wasNull(rs)) {
            return null;
        }

        return value;
    }
}
