package sharin.unlinq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicLookup<TKey, TSource> implements Lookup<TKey, TSource> {

    private final Map<TKey, List<TSource>> map;

    public BasicLookup() {
        this(null);
    }

    public BasicLookup(Map<TKey, List<TSource>> map) {

        if (map == null) {
            map = new LinkedHashMap<TKey, List<TSource>>();
        }

        this.map = map;
    }

    private Enumerable<Grouping<TKey, TSource>> getEnumerable() {
        List<Grouping<TKey, TSource>> list = new ArrayList<Grouping<TKey, TSource>>();

        for (Entry<TKey, List<TSource>> entry : map.entrySet()) {
            list.add(new BasicGrouping<TKey, TSource>(entry.getKey(), entry
                    .getValue()));
        }

        return new BasicEnumerable<Grouping<TKey, TSource>>(list);
    }

    @Override
    public String toString() {
        return map.toString();
    }

    public void clear() {
        map.clear();
    }

    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return map.containsValue(value);
    }

    public Set<Entry<TKey, List<TSource>>> entrySet() {
        return map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return map.equals(o);
    }

    public List<TSource> get(Object key) {
        return map.get(key);
    }

    @Override
    public int hashCode() {
        return map.hashCode();
    }

    public boolean isEmpty() {
        return map.isEmpty();
    }

    public Set<TKey> keySet() {
        return map.keySet();
    }

    public List<TSource> put(TKey key, List<TSource> value) {
        return map.put(key, value);
    }

    public void putAll(Map<? extends TKey, ? extends List<TSource>> t) {
        map.putAll(t);
    }

    public List<TSource> remove(Object key) {
        return map.remove(key);
    }

    public int size() {
        return map.size();
    }

    public Collection<List<TSource>> values() {
        return map.values();
    }

    public <A, R> R aggregate(A seed,
            Func2<A, Grouping<TKey, TSource>, A> func, Func<A, R> resultSelector) {
        return getEnumerable().aggregate(seed, func, resultSelector);
    }

    public <A> A aggregate(A seed, Func2<A, Grouping<TKey, TSource>, A> func) {
        return getEnumerable().aggregate(seed, func);
    }

    public Grouping<TKey, TSource> aggregate(
            Func2<Grouping<TKey, TSource>, Grouping<TKey, TSource>, Grouping<TKey, TSource>> func) {
        return getEnumerable().aggregate(func);
    }

    public Boolean all(Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().all(predicate);
    }

    public Boolean any() {
        return getEnumerable().any();
    }

    public Boolean any(Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().any(predicate);
    }

    public double average() {
        return getEnumerable().average();
    }

    public double average(Func<Grouping<TKey, TSource>, Integer> selector) {
        return getEnumerable().average(selector);
    }

    public double averageDouble() {
        return getEnumerable().averageDouble();
    }

    public double averageDouble(Func<Grouping<TKey, TSource>, Double> selector) {
        return getEnumerable().averageDouble(selector);
    }

    public float averageFloat() {
        return getEnumerable().averageFloat();
    }

    public float averageFloat(Func<Grouping<TKey, TSource>, Float> selector) {
        return getEnumerable().averageFloat(selector);
    }

    public double averageLong() {
        return getEnumerable().averageLong();
    }

    public double averageLong(Func<Grouping<TKey, TSource>, Long> selector) {
        return getEnumerable().averageLong(selector);
    }

    public <R> Enumerable<R> cast(Class<R> resultClass) {
        return getEnumerable().cast(resultClass);
    }

    public Enumerable<Grouping<TKey, TSource>> concat(
            Enumerable<Grouping<TKey, TSource>> second) {
        return getEnumerable().concat(second);
    }

    public boolean contains(Object o) {
        return getEnumerable().contains(o);
    }

    public int count() {
        return getEnumerable().count();
    }

    public int count(Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().count(predicate);
    }

    public Enumerable<Grouping<TKey, TSource>> defaultIfEmpty() {
        return getEnumerable().defaultIfEmpty();
    }

    public Enumerable<Grouping<TKey, TSource>> defaultIfEmpty(
            Grouping<TKey, TSource> defaultValue) {
        return getEnumerable().defaultIfEmpty(defaultValue);
    }

    public Enumerable<Grouping<TKey, TSource>> distinct() {
        return getEnumerable().distinct();
    }

    public Grouping<TKey, TSource> elementAt(int index) {
        return getEnumerable().elementAt(index);
    }

    public Grouping<TKey, TSource> elementAtOrDefault(int index,
            Grouping<TKey, TSource> defaultValue) {
        return getEnumerable().elementAtOrDefault(index, defaultValue);
    }

    public Grouping<TKey, TSource> elementAtOrDefault(int index) {
        return getEnumerable().elementAtOrDefault(index);
    }

    public Enumerable<Grouping<TKey, TSource>> except(
            Enumerable<Grouping<TKey, TSource>> second) {
        return getEnumerable().except(second);
    }

    public Grouping<TKey, TSource> first() {
        return getEnumerable().first();
    }

    public Grouping<TKey, TSource> first(
            Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().first(predicate);
    }

    public Grouping<TKey, TSource> firstOrDefault() {
        return getEnumerable().firstOrDefault();
    }

    public Grouping<TKey, TSource> firstOrDefault(
            Func<Grouping<TKey, TSource>, Boolean> predicate,
            Grouping<TKey, TSource> defaultValue) {
        return getEnumerable().firstOrDefault(predicate, defaultValue);
    }

    public Grouping<TKey, TSource> firstOrDefault(
            Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().firstOrDefault(predicate);
    }

    public Grouping<TKey, TSource> firstOrDefault(
            Grouping<TKey, TSource> defaultValue) {
        return getEnumerable().firstOrDefault(defaultValue);
    }

    public <K, E, R> Enumerable<R> groupBy(
            Func<Grouping<TKey, TSource>, K> keySelector,
            Func<Grouping<TKey, TSource>, E> elementSelector,
            Func2<K, Enumerable<E>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector,
                resultSelector);
    }

    public <K, E> Enumerable<Grouping<K, E>> groupBy(
            Func<Grouping<TKey, TSource>, K> keySelector,
            Func<Grouping<TKey, TSource>, E> elementSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector);
    }

    public <K, R> Enumerable<R> groupBy(
            Func<Grouping<TKey, TSource>, K> keySelector,
            Func2<K, Enumerable<Grouping<TKey, TSource>>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, resultSelector);
    }

    public <K> Enumerable<Grouping<K, Grouping<TKey, TSource>>> groupBy(
            Func<Grouping<TKey, TSource>, K> keySelector) {
        return getEnumerable().groupBy(keySelector);
    }

    public <I, K, R> Enumerable<R> groupJoin(Enumerable<I> inner,
            Func<Grouping<TKey, TSource>, K> outerKeySelector,
            Func<I, K> innerKeySelector,
            Func2<Grouping<TKey, TSource>, Enumerable<I>, R> resultSelector) {
        return getEnumerable().groupJoin(inner, outerKeySelector,
                innerKeySelector, resultSelector);
    }

    public Enumerable<Grouping<TKey, TSource>> intersect(
            Enumerable<Grouping<TKey, TSource>> second) {
        return getEnumerable().intersect(second);
    }

    public Iterator<Grouping<TKey, TSource>> iterator() {
        return getEnumerable().iterator();
    }

    public <I, K, R> Enumerable<R> join(Enumerable<I> inner,
            Func<Grouping<TKey, TSource>, K> outerKeySelector,
            Func<I, K> innerKeySelector,
            Func2<Grouping<TKey, TSource>, I, R> resultSelector) {
        return getEnumerable().join(inner, outerKeySelector, innerKeySelector,
                resultSelector);
    }

    public Grouping<TKey, TSource> last() {
        return getEnumerable().last();
    }

    public Grouping<TKey, TSource> last(
            Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().last(predicate);
    }

    public Grouping<TKey, TSource> lastOrDefault() {
        return getEnumerable().lastOrDefault();
    }

    public Grouping<TKey, TSource> lastOrDefault(
            Func<Grouping<TKey, TSource>, Boolean> predicate,
            Grouping<TKey, TSource> defaultValue) {
        return getEnumerable().lastOrDefault(predicate, defaultValue);
    }

    public Grouping<TKey, TSource> lastOrDefault(
            Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().lastOrDefault(predicate);
    }

    public Grouping<TKey, TSource> lastOrDefault(
            Grouping<TKey, TSource> defaultValue) {
        return getEnumerable().lastOrDefault(defaultValue);
    }

    public long longCount() {
        return getEnumerable().longCount();
    }

    public long longCount(Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().longCount(predicate);
    }

    public Grouping<TKey, TSource> max() {
        return getEnumerable().max();
    }

    public <R extends Comparable<R>> R max(
            Func<Grouping<TKey, TSource>, R> selector) {
        return getEnumerable().max(selector);
    }

    public Grouping<TKey, TSource> min() {
        return getEnumerable().min();
    }

    public <R extends Comparable<R>> R min(
            Func<Grouping<TKey, TSource>, R> selector) {
        return getEnumerable().min(selector);
    }

    public <R> Enumerable<R> ofType(Class<R> resultClass) {
        return getEnumerable().ofType(resultClass);
    }

    public <K> OrderedEnumerable<Grouping<TKey, TSource>> orderBy(
            Func<Grouping<TKey, TSource>, K> keySelector,
            Comparator<K> comparator) {
        return getEnumerable().orderBy(keySelector, comparator);
    }

    public <K> OrderedEnumerable<Grouping<TKey, TSource>> orderBy(
            Func<Grouping<TKey, TSource>, K> keySelector) {
        return getEnumerable().orderBy(keySelector);
    }

    public <K> OrderedEnumerable<Grouping<TKey, TSource>> orderByDescending(
            Func<Grouping<TKey, TSource>, K> keySelector,
            Comparator<K> comparator) {
        return getEnumerable().orderByDescending(keySelector, comparator);
    }

    public <K> OrderedEnumerable<Grouping<TKey, TSource>> orderByDescending(
            Func<Grouping<TKey, TSource>, K> keySelector) {
        return getEnumerable().orderByDescending(keySelector);
    }

    public Enumerable<Grouping<TKey, TSource>> reverse() {
        return getEnumerable().reverse();
    }

    public <R> Enumerable<R> select(Func<Grouping<TKey, TSource>, R> selector) {
        return getEnumerable().select(selector);
    }

    public <R> Enumerable<R> select(
            Func2<Grouping<TKey, TSource>, Integer, R> selector) {
        return getEnumerable().select(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func<Grouping<TKey, TSource>, Enumerable<C>> collectionSelector,
            Func2<Grouping<TKey, TSource>, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(
            Func<Grouping<TKey, TSource>, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func2<Grouping<TKey, TSource>, Integer, Enumerable<C>> collectionSelector,
            Func2<Grouping<TKey, TSource>, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(
            Func2<Grouping<TKey, TSource>, Integer, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public Boolean sequenceEqual(Enumerable<Grouping<TKey, TSource>> second) {
        return getEnumerable().sequenceEqual(second);
    }

    public Grouping<TKey, TSource> single() {
        return getEnumerable().single();
    }

    public Grouping<TKey, TSource> single(
            Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().single(predicate);
    }

    public Grouping<TKey, TSource> singleOrDefault() {
        return getEnumerable().singleOrDefault();
    }

    public Grouping<TKey, TSource> singleOrDefault(
            Func<Grouping<TKey, TSource>, Boolean> predicate,
            Grouping<TKey, TSource> defaultValue) {
        return getEnumerable().singleOrDefault(predicate, defaultValue);
    }

    public Grouping<TKey, TSource> singleOrDefault(
            Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().singleOrDefault(predicate);
    }

    public Grouping<TKey, TSource> singleOrDefault(
            Grouping<TKey, TSource> defaultValue) {
        return getEnumerable().singleOrDefault(defaultValue);
    }

    public Enumerable<Grouping<TKey, TSource>> skip(int count) {
        return getEnumerable().skip(count);
    }

    public Enumerable<Grouping<TKey, TSource>> skipWhile(
            Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public Enumerable<Grouping<TKey, TSource>> skipWhile(
            Func2<Grouping<TKey, TSource>, Integer, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public int sum() {
        return getEnumerable().sum();
    }

    public int sum(Func<Grouping<TKey, TSource>, Integer> selector) {
        return getEnumerable().sum(selector);
    }

    public double sumDouble() {
        return getEnumerable().sumDouble();
    }

    public double sumDouble(Func<Grouping<TKey, TSource>, Double> selector) {
        return getEnumerable().sumDouble(selector);
    }

    public float sumFloat() {
        return getEnumerable().sumFloat();
    }

    public float sumFloat(Func<Grouping<TKey, TSource>, Float> selector) {
        return getEnumerable().sumFloat(selector);
    }

    public long sumLong() {
        return getEnumerable().sumLong();
    }

    public long sumLong(Func<Grouping<TKey, TSource>, Long> selector) {
        return getEnumerable().sumLong(selector);
    }

    public Enumerable<Grouping<TKey, TSource>> take(int count) {
        return getEnumerable().take(count);
    }

    public Enumerable<Grouping<TKey, TSource>> takeWhile(
            Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public Enumerable<Grouping<TKey, TSource>> takeWhile(
            Func2<Grouping<TKey, TSource>, Integer, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public Object[] toArray() {
        return getEnumerable().toArray();
    }

    public <R> R[] toArray(Class<R> resultClass) {
        return getEnumerable().toArray(resultClass);
    }

    public <K, E> Dictionary<K, E> toDictionary(
            Func<Grouping<TKey, TSource>, K> keySelector,
            Func<Grouping<TKey, TSource>, E> elementSelector) {
        return getEnumerable().toDictionary(keySelector, elementSelector);
    }

    public <K> Dictionary<K, Grouping<TKey, TSource>> toDictionary(
            Func<Grouping<TKey, TSource>, K> keySelector) {
        return getEnumerable().toDictionary(keySelector);
    }

    public EnumerableList<Grouping<TKey, TSource>> toEnumerableList() {
        return getEnumerable().toEnumerableList();
    }

    public List<Grouping<TKey, TSource>> toList() {
        return getEnumerable().toList();
    }

    public <K, E> Map<K, List<E>> toListMap(
            Func<Grouping<TKey, TSource>, K> keySelector,
            Func<Grouping<TKey, TSource>, E> elementSelector) {
        return getEnumerable().toListMap(keySelector, elementSelector);
    }

    public <K> Map<K, List<Grouping<TKey, TSource>>> toListMap(
            Func<Grouping<TKey, TSource>, K> keySelector) {
        return getEnumerable().toListMap(keySelector);
    }

    public <K, E> Lookup<K, E> toLookup(
            Func<Grouping<TKey, TSource>, K> keySelector,
            Func<Grouping<TKey, TSource>, E> elementSelector) {
        return getEnumerable().toLookup(keySelector, elementSelector);
    }

    public <K> Lookup<K, Grouping<TKey, TSource>> toLookup(
            Func<Grouping<TKey, TSource>, K> keySelector) {
        return getEnumerable().toLookup(keySelector);
    }

    public <K, E> Map<K, E> toMap(Func<Grouping<TKey, TSource>, K> keySelector,
            Func<Grouping<TKey, TSource>, E> elementSelector) {
        return getEnumerable().toMap(keySelector, elementSelector);
    }

    public <K> Map<K, Grouping<TKey, TSource>> toMap(
            Func<Grouping<TKey, TSource>, K> keySelector) {
        return getEnumerable().toMap(keySelector);
    }

    public Enumerable<Grouping<TKey, TSource>> union(
            Enumerable<Grouping<TKey, TSource>> second) {
        return getEnumerable().union(second);
    }

    public Enumerable<Grouping<TKey, TSource>> where(
            Func<Grouping<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }

    public Enumerable<Grouping<TKey, TSource>> where(
            Func2<Grouping<TKey, TSource>, Integer, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }

    public Enumerable<Grouping<TKey, TSource>> asEnumerable() {
        return getEnumerable().asEnumerable();
    }
}
