package sharin.unlinq;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class BasicOrderedEnumerable<TSource> extends BasicEnumerable<TSource>
        implements OrderedEnumerable<TSource> {

    public BasicOrderedEnumerable(Iterable<TSource> iterable) {
        super(iterable);
    }

    /**
     * This method is Deferred Non-Streaming Execution.
     */
    public <K> OrderedEnumerable<TSource> thenBy(Func<TSource, K> keySelector) {
        return thenBy(keySelector, null);
    }

    /**
     * This method is Deferred Non-Streaming Execution.
     */
    public <K> OrderedEnumerable<TSource> thenBy(
            final Func<TSource, K> keySelector, final Comparator<K> comparator) {

        return new BasicOrderedEnumerable<TSource>(new Iterable<TSource>() {

            public Iterator<TSource> iterator() {
                return new OrderedIterator<TSource>(getGroupList(),
                        keySelector, comparator);
            }
        });
    }

    /**
     * This method is Deferred Non-Streaming Execution.
     */
    public <K> OrderedEnumerable<TSource> thenByDescending(
            Func<TSource, K> keySelector) {

        return thenBy(keySelector, Collections
                .reverseOrder((Comparator<K>) null));
    }

    /**
     * This method is Deferred Non-Streaming Execution.
     */
    public <K> OrderedEnumerable<TSource> thenByDescending(
            Func<TSource, K> keySelector, Comparator<K> comparator) {

        return thenBy(keySelector, Collections.reverseOrder(comparator));
    }

    @Override
    public OrderedIterator<TSource> iterator() {
        return (OrderedIterator<TSource>) super.iterator();
    }

    private List<List<TSource>> getGroupList() {
        return iterator().getGroupList();
    }
}
