package sharin.unlinq;

import java.util.Iterator;

public class ConcatenatedIterator<T> implements Iterator<T> {

    private final Iterator<T> firstIterator;

    private final Iterable<T> selcondIterable;

    private Iterator<T> iterator;

    public ConcatenatedIterator(Iterator<T> firstIterator,
            Iterable<T> secondIterable) {

        this.firstIterator = firstIterator;
        this.selcondIterable = secondIterable;
        this.iterator = firstIterator;
    }

    public boolean hasNext() {

        if (iterator.hasNext()) {
            return true;
        }

        if (iterator != firstIterator) {
            return false;
        }

        iterator = selcondIterable.iterator();
        return iterator.hasNext();
    }

    public T next() {
        return iterator.next();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

}
