package sharin.unlinq.iterable;

import java.util.Iterator;

public class CastIterable<T, R> implements Iterable<R> {

    private final Iterable<T> iterable;

    private final Class<R> resultClass;

    public CastIterable(Iterable<T> iterable, Class<R> resultClass) {
        this.iterable = iterable;
        this.resultClass = resultClass;
    }

    public Iterator<R> iterator() {
        return new Iterator<R>() {

            private final Iterator<T> iterator = iterable.iterator();

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public R next() {
                return resultClass.cast(iterator.next());
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}
