package sharin.unlinq.iterable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DefaultIfEmptyIterable<T> implements Iterable<T> {

    private final Iterable<T> iterable;

    private final T defaultValue;

    public DefaultIfEmptyIterable(Iterable<T> iterable, T defaultValue) {
        this.iterable = iterable;
        this.defaultValue = defaultValue;
    }

    public Iterator<T> iterator() {
        return new Iterator<T>() {

            private Iterator<T> iterator;

            {
                iterator = iterable.iterator();

                if (!iterator.hasNext()) {
                    List<T> list = new ArrayList<T>();
                    list.add(defaultValue);
                    iterator = list.iterator();
                }
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public T next() {
                return iterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}
