package sharin.unlinq.iterable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

import sharin.unlinq.QueuedIterator;

public class DistinctIterable<T> implements Iterable<T> {

    private final Iterable<T> iterable;

    public DistinctIterable(Iterable<T> iterable) {
        this.iterable = iterable;
    }

    public Iterator<T> iterator() {
        return new QueuedIterator<T, T, T>(iterable.iterator()) {

            private final Set<T> set = new HashSet<T>();

            @Override
            protected void addElement(Queue<T> queue, T t) {

                if (!set.contains(t)) {
                    queue.add(t);
                    set.add(t);
                }
            }

            @Override
            protected T toResult(T e) {
                return e;
            }
        };
    }
}
