package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class SkipIterable<T> implements Iterable<T> {

    private final Iterable<T> iterable;
    private final int count;

    public SkipIterable(Iterable<T> iterable, int count) {
        this.iterable = iterable;
        this.count = count;
    }

    public Iterator<T> iterator() {
        return new Iterator<T>() {

            private final Iterator<T> iterator = iterable.iterator();

            private boolean skipped;

            private boolean skip() {

                if (skipped) {
                    return true;
                }

                skipped = true;

                for (int i = 0; i < count; i++) {

                    if (!iterator.hasNext()) {
                        return false;
                    }

                    iterator.next();
                }

                return true;
            }

            public boolean hasNext() {

                if (!skip()) {
                    return false;
                }

                return iterator.hasNext();
            }

            public T next() {

                if (!skip()) {
                    throw new NoSuchElementException();
                }

                return iterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}
