package sharin.doc.builder;

import java.util.ArrayList;
import java.util.List;

public class Elem {

    private String name;

    private final List<Attr> attrList = new ArrayList<Attr>();

    private final List<Object> nodeList = new ArrayList<Object>();

    public Elem(String name, Object... nodes) {
        this.name = name;
        _(nodes);
    }

    public Elem attr(String name, Object value) {
        Attr attr = new Attr(name, value);
        attrList.add(attr);
        return this;
    }

    public Elem _(Object... nodes) {

        for (Object node : nodes) {
            nodeList.add(node);
        }

        return this;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Attr> getAttrList() {
        return attrList;
    }

    public List<Object> getNodeList() {
        return nodeList;
    }
}
