package sharin.unlinq;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BasicDictionary<TKey, TSource> implements
        Dictionary<TKey, TSource> {

    private Map<TKey, TSource> map;

    public BasicDictionary() {
        this(null);
    }

    public BasicDictionary(Map<TKey, TSource> map) {

        if (map == null) {
            map = new LinkedHashMap<TKey, TSource>();
        }

        this.map = map;
    }

    private Enumerable<Entry<TKey, TSource>> getEnumerable() {
        return new BasicEnumerable<Entry<TKey, TSource>>(map.entrySet());
    }

    @Override
    public String toString() {
        return map.toString();
    }

    public void clear() {
        map.clear();
    }

    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return map.containsValue(value);
    }

    public Set<Entry<TKey, TSource>> entrySet() {
        return map.entrySet();
    }

    public TSource get(Object key) {
        return map.get(key);
    }

    public boolean isEmpty() {
        return map.isEmpty();
    }

    public Set<TKey> keySet() {
        return map.keySet();
    }

    public TSource put(TKey key, TSource value) {
        return map.put(key, value);
    }

    public void putAll(Map<? extends TKey, ? extends TSource> t) {
        map.putAll(t);
    }

    public TSource remove(Object key) {
        return map.remove(key);
    }

    public int size() {
        return map.size();
    }

    public Collection<TSource> values() {
        return map.values();
    }

    public <A, R> R aggregate(A seed, Func2<A, Entry<TKey, TSource>, A> func,
            Func<A, R> resultSelector) {
        return getEnumerable().aggregate(seed, func, resultSelector);
    }

    public <A> A aggregate(A seed, Func2<A, Entry<TKey, TSource>, A> func) {
        return getEnumerable().aggregate(seed, func);
    }

    public Entry<TKey, TSource> aggregate(
            Func2<Entry<TKey, TSource>, Entry<TKey, TSource>, Entry<TKey, TSource>> func) {
        return getEnumerable().aggregate(func);
    }

    public Boolean all(Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().all(predicate);
    }

    public Boolean any() {
        return getEnumerable().any();
    }

    public Boolean any(Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().any(predicate);
    }

    public double average() {
        return getEnumerable().average();
    }

    public double average(Func<Entry<TKey, TSource>, Integer> selector) {
        return getEnumerable().average(selector);
    }

    public double averageDouble() {
        return getEnumerable().averageDouble();
    }

    public double averageDouble(Func<Entry<TKey, TSource>, Double> selector) {
        return getEnumerable().averageDouble(selector);
    }

    public float averageFloat() {
        return getEnumerable().averageFloat();
    }

    public float averageFloat(Func<Entry<TKey, TSource>, Float> selector) {
        return getEnumerable().averageFloat(selector);
    }

    public double averageLong() {
        return getEnumerable().averageLong();
    }

    public double averageLong(Func<Entry<TKey, TSource>, Long> selector) {
        return getEnumerable().averageLong(selector);
    }

    public <R> Enumerable<R> cast(Class<R> resultClass) {
        return getEnumerable().cast(resultClass);
    }

    public Enumerable<Entry<TKey, TSource>> concat(
            Enumerable<Entry<TKey, TSource>> second) {
        return getEnumerable().concat(second);
    }

    public boolean contains(Object o) {
        return getEnumerable().contains(o);
    }

    public int count() {
        return getEnumerable().count();
    }

    public int count(Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().count(predicate);
    }

    public Enumerable<Entry<TKey, TSource>> defaultIfEmpty() {
        return getEnumerable().defaultIfEmpty();
    }

    public Enumerable<Entry<TKey, TSource>> defaultIfEmpty(
            Entry<TKey, TSource> defaultValue) {
        return getEnumerable().defaultIfEmpty(defaultValue);
    }

    public Enumerable<Entry<TKey, TSource>> distinct() {
        return getEnumerable().distinct();
    }

    public Entry<TKey, TSource> elementAt(int index) {
        return getEnumerable().elementAt(index);
    }

    public Entry<TKey, TSource> elementAtOrDefault(int index,
            Entry<TKey, TSource> defaultValue) {
        return getEnumerable().elementAtOrDefault(index, defaultValue);
    }

    public Entry<TKey, TSource> elementAtOrDefault(int index) {
        return getEnumerable().elementAtOrDefault(index);
    }

    public Enumerable<Entry<TKey, TSource>> except(
            Enumerable<Entry<TKey, TSource>> second) {
        return getEnumerable().except(second);
    }

    public Entry<TKey, TSource> first() {
        return getEnumerable().first();
    }

    public Entry<TKey, TSource> first(
            Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().first(predicate);
    }

    public Entry<TKey, TSource> firstOrDefault() {
        return getEnumerable().firstOrDefault();
    }

    public Entry<TKey, TSource> firstOrDefault(Entry<TKey, TSource> defaultValue) {
        return getEnumerable().firstOrDefault(defaultValue);
    }

    public Entry<TKey, TSource> firstOrDefault(
            Func<Entry<TKey, TSource>, Boolean> predicate,
            Entry<TKey, TSource> defaultValue) {
        return getEnumerable().firstOrDefault(predicate, defaultValue);
    }

    public Entry<TKey, TSource> firstOrDefault(
            Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().firstOrDefault(predicate);
    }

    public <K, E, R> Enumerable<R> groupBy(
            Func<Entry<TKey, TSource>, K> keySelector,
            Func<Entry<TKey, TSource>, E> elementSelector,
            Func2<K, Enumerable<E>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector,
                resultSelector);
    }

    public <K, E> Enumerable<Grouping<K, E>> groupBy(
            Func<Entry<TKey, TSource>, K> keySelector,
            Func<Entry<TKey, TSource>, E> elementSelector) {
        return getEnumerable().groupBy(keySelector, elementSelector);
    }

    public <K, R> Enumerable<R> groupBy(
            Func<Entry<TKey, TSource>, K> keySelector,
            Func2<K, Enumerable<Entry<TKey, TSource>>, R> resultSelector) {
        return getEnumerable().groupBy(keySelector, resultSelector);
    }

    public <K> Enumerable<Grouping<K, Entry<TKey, TSource>>> groupBy(
            Func<Entry<TKey, TSource>, K> keySelector) {
        return getEnumerable().groupBy(keySelector);
    }

    public <I, K, R> Enumerable<R> groupJoin(Enumerable<I> inner,
            Func<Entry<TKey, TSource>, K> outerKeySelector,
            Func<I, K> innerKeySelector,
            Func2<Entry<TKey, TSource>, Enumerable<I>, R> resultSelector) {
        return getEnumerable().groupJoin(inner, outerKeySelector,
                innerKeySelector, resultSelector);
    }

    public Enumerable<Entry<TKey, TSource>> intersect(
            Enumerable<Entry<TKey, TSource>> second) {
        return getEnumerable().intersect(second);
    }

    public Iterator<Entry<TKey, TSource>> iterator() {
        return getEnumerable().iterator();
    }

    public <I, K, R> Enumerable<R> join(Enumerable<I> inner,
            Func<Entry<TKey, TSource>, K> outerKeySelector,
            Func<I, K> innerKeySelector,
            Func2<Entry<TKey, TSource>, I, R> resultSelector) {
        return getEnumerable().join(inner, outerKeySelector, innerKeySelector,
                resultSelector);
    }

    public Entry<TKey, TSource> last() {
        return getEnumerable().last();
    }

    public Entry<TKey, TSource> last(
            Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().last(predicate);
    }

    public Entry<TKey, TSource> lastOrDefault() {
        return getEnumerable().lastOrDefault();
    }

    public Entry<TKey, TSource> lastOrDefault(Entry<TKey, TSource> defaultValue) {
        return getEnumerable().lastOrDefault(defaultValue);
    }

    public Entry<TKey, TSource> lastOrDefault(
            Func<Entry<TKey, TSource>, Boolean> predicate,
            Entry<TKey, TSource> defaultValue) {
        return getEnumerable().lastOrDefault(predicate, defaultValue);
    }

    public Entry<TKey, TSource> lastOrDefault(
            Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().lastOrDefault(predicate);
    }

    public long longCount() {
        return getEnumerable().longCount();
    }

    public long longCount(Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().longCount(predicate);
    }

    public Entry<TKey, TSource> max() {
        return getEnumerable().max();
    }

    public <R extends Comparable<R>> R max(
            Func<Entry<TKey, TSource>, R> selector) {
        return getEnumerable().max(selector);
    }

    public Entry<TKey, TSource> min() {
        return getEnumerable().min();
    }

    public <R extends Comparable<R>> R min(
            Func<Entry<TKey, TSource>, R> selector) {
        return getEnumerable().min(selector);
    }

    public <R> Enumerable<R> ofType(Class<R> resultClass) {
        return getEnumerable().ofType(resultClass);
    }

    public <K> OrderedEnumerable<Entry<TKey, TSource>> orderBy(
            Func<Entry<TKey, TSource>, K> keySelector, Comparator<K> comparator) {
        return getEnumerable().orderBy(keySelector, comparator);
    }

    public <K> OrderedEnumerable<Entry<TKey, TSource>> orderBy(
            Func<Entry<TKey, TSource>, K> keySelector) {
        return getEnumerable().orderBy(keySelector);
    }

    public <K> OrderedEnumerable<Entry<TKey, TSource>> orderByDescending(
            Func<Entry<TKey, TSource>, K> keySelector, Comparator<K> comparator) {
        return getEnumerable().orderByDescending(keySelector, comparator);
    }

    public <K> OrderedEnumerable<Entry<TKey, TSource>> orderByDescending(
            Func<Entry<TKey, TSource>, K> keySelector) {
        return getEnumerable().orderByDescending(keySelector);
    }

    public Enumerable<Entry<TKey, TSource>> reverse() {
        return getEnumerable().reverse();
    }

    public <R> Enumerable<R> select(Func<Entry<TKey, TSource>, R> selector) {
        return getEnumerable().select(selector);
    }

    public <R> Enumerable<R> select(
            Func2<Entry<TKey, TSource>, Integer, R> selector) {
        return getEnumerable().select(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func<Entry<TKey, TSource>, Enumerable<C>> collectionSelector,
            Func2<Entry<TKey, TSource>, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(
            Func<Entry<TKey, TSource>, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public <C, R> Enumerable<R> selectMany(
            Func2<Entry<TKey, TSource>, Integer, Enumerable<C>> collectionSelector,
            Func2<Entry<TKey, TSource>, C, R> resultSelector) {
        return getEnumerable().selectMany(collectionSelector, resultSelector);
    }

    public <R> Enumerable<R> selectMany(
            Func2<Entry<TKey, TSource>, Integer, Enumerable<R>> selector) {
        return getEnumerable().selectMany(selector);
    }

    public Boolean sequenceEqual(Enumerable<Entry<TKey, TSource>> second) {
        return getEnumerable().sequenceEqual(second);
    }

    public Entry<TKey, TSource> single() {
        return getEnumerable().single();
    }

    public Entry<TKey, TSource> single(
            Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().single(predicate);
    }

    public Entry<TKey, TSource> singleOrDefault() {
        return getEnumerable().singleOrDefault();
    }

    public Entry<TKey, TSource> singleOrDefault(
            Entry<TKey, TSource> defaultValue) {
        return getEnumerable().singleOrDefault(defaultValue);
    }

    public Entry<TKey, TSource> singleOrDefault(
            Func<Entry<TKey, TSource>, Boolean> predicate,
            Entry<TKey, TSource> defaultValue) {
        return getEnumerable().singleOrDefault(predicate, defaultValue);
    }

    public Entry<TKey, TSource> singleOrDefault(
            Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().singleOrDefault(predicate);
    }

    public Enumerable<Entry<TKey, TSource>> skip(int count) {
        return getEnumerable().skip(count);
    }

    public Enumerable<Entry<TKey, TSource>> skipWhile(
            Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public Enumerable<Entry<TKey, TSource>> skipWhile(
            Func2<Entry<TKey, TSource>, Integer, Boolean> predicate) {
        return getEnumerable().skipWhile(predicate);
    }

    public int sum() {
        return getEnumerable().sum();
    }

    public int sum(Func<Entry<TKey, TSource>, Integer> selector) {
        return getEnumerable().sum(selector);
    }

    public double sumDouble() {
        return getEnumerable().sumDouble();
    }

    public double sumDouble(Func<Entry<TKey, TSource>, Double> selector) {
        return getEnumerable().sumDouble(selector);
    }

    public float sumFloat() {
        return getEnumerable().sumFloat();
    }

    public float sumFloat(Func<Entry<TKey, TSource>, Float> selector) {
        return getEnumerable().sumFloat(selector);
    }

    public long sumLong() {
        return getEnumerable().sumLong();
    }

    public long sumLong(Func<Entry<TKey, TSource>, Long> selector) {
        return getEnumerable().sumLong(selector);
    }

    public Enumerable<Entry<TKey, TSource>> take(int count) {
        return getEnumerable().take(count);
    }

    public Enumerable<Entry<TKey, TSource>> takeWhile(
            Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public Enumerable<Entry<TKey, TSource>> takeWhile(
            Func2<Entry<TKey, TSource>, Integer, Boolean> predicate) {
        return getEnumerable().takeWhile(predicate);
    }

    public Object[] toArray() {
        return getEnumerable().toArray();
    }

    public <R> R[] toArray(Class<R> resultClass) {
        return getEnumerable().toArray(resultClass);
    }

    public <K, E> Dictionary<K, E> toDictionary(
            Func<Entry<TKey, TSource>, K> keySelector,
            Func<Entry<TKey, TSource>, E> elementSelector) {
        return getEnumerable().toDictionary(keySelector, elementSelector);
    }

    public <K> Dictionary<K, Entry<TKey, TSource>> toDictionary(
            Func<Entry<TKey, TSource>, K> keySelector) {
        return getEnumerable().toDictionary(keySelector);
    }

    public EnumerableList<Entry<TKey, TSource>> toEnumerableList() {
        return getEnumerable().toEnumerableList();
    }

    public List<Entry<TKey, TSource>> toList() {
        return getEnumerable().toList();
    }

    public <K, E> Map<K, List<E>> toListMap(
            Func<Entry<TKey, TSource>, K> keySelector,
            Func<Entry<TKey, TSource>, E> elementSelector) {
        return getEnumerable().toListMap(keySelector, elementSelector);
    }

    public <K> Map<K, List<Entry<TKey, TSource>>> toListMap(
            Func<Entry<TKey, TSource>, K> keySelector) {
        return getEnumerable().toListMap(keySelector);
    }

    public <K, E> Lookup<K, E> toLookup(
            Func<Entry<TKey, TSource>, K> keySelector,
            Func<Entry<TKey, TSource>, E> elementSelector) {
        return getEnumerable().toLookup(keySelector, elementSelector);
    }

    public <K> Lookup<K, Entry<TKey, TSource>> toLookup(
            Func<Entry<TKey, TSource>, K> keySelector) {
        return getEnumerable().toLookup(keySelector);
    }

    public <K, E> Map<K, E> toMap(Func<Entry<TKey, TSource>, K> keySelector,
            Func<Entry<TKey, TSource>, E> elementSelector) {
        return getEnumerable().toMap(keySelector, elementSelector);
    }

    public <K> Map<K, Entry<TKey, TSource>> toMap(
            Func<Entry<TKey, TSource>, K> keySelector) {
        return getEnumerable().toMap(keySelector);
    }

    public Enumerable<Entry<TKey, TSource>> union(
            Enumerable<Entry<TKey, TSource>> second) {
        return getEnumerable().union(second);
    }

    public Enumerable<Entry<TKey, TSource>> where(
            Func<Entry<TKey, TSource>, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }

    public Enumerable<Entry<TKey, TSource>> where(
            Func2<Entry<TKey, TSource>, Integer, Boolean> predicate) {
        return getEnumerable().where(predicate);
    }

    public Enumerable<java.util.Map.Entry<TKey, TSource>> asEnumerable() {
        return getEnumerable().asEnumerable();
    }
}
