package sharin.unlinq;

import java.util.Comparator;
import java.util.List;
import java.util.Map;

public interface Enumerable<TSource> extends Iterable<TSource> {

    public TSource aggregate(Func2<TSource, TSource, TSource> func);

    public <A> A aggregate(A seed, Func2<A, TSource, A> func);

    public <A, R> R aggregate(A seed, Func2<A, TSource, A> func,
            Func<A, R> resultSelector);

    public Boolean all(Func<TSource, Boolean> predicate);

    public Boolean any();

    public Boolean any(Func<TSource, Boolean> predicate);

    public Enumerable<TSource> asEnumerable();

    public double average();

    public double averageLong();

    public float averageFloat();

    public double averageDouble();

    public double average(Func<TSource, Integer> selector);

    public double averageLong(Func<TSource, Long> selector);

    public float averageFloat(Func<TSource, Float> selector);

    public double averageDouble(Func<TSource, Double> selector);

    public <R> Enumerable<R> cast(Class<R> resultClass);

    public Enumerable<TSource> concat(Enumerable<TSource> second);

    public boolean contains(Object o);

    public int count();

    public int count(Func<TSource, Boolean> predicate);

    public Enumerable<TSource> defaultIfEmpty();

    public Enumerable<TSource> defaultIfEmpty(TSource defaultValue);

    public Enumerable<TSource> distinct();

    public TSource elementAt(int index);

    public TSource elementAtOrDefault(int index);

    public TSource elementAtOrDefault(int index, TSource defaultValue);

    public Enumerable<TSource> except(Enumerable<TSource> second);

    public TSource first();

    public TSource first(Func<TSource, Boolean> predicate);

    public TSource firstOrDefault();

    public TSource firstOrDefault(TSource defaultValue);

    public TSource firstOrDefault(Func<TSource, Boolean> predicate);

    public TSource firstOrDefault(Func<TSource, Boolean> predicate,
            TSource defaultValue);

    public <K> Enumerable<Grouping<K, TSource>> groupBy(
            Func<TSource, K> keySelector);

    public <K, R> Enumerable<R> groupBy(Func<TSource, K> keySelector,
            Func2<K, Enumerable<TSource>, R> resultSelector);

    public <K, E> Enumerable<Grouping<K, E>> groupBy(
            Func<TSource, K> keySelector, Func<TSource, E> elementSelector);

    public <K, E, R> Enumerable<R> groupBy(Func<TSource, K> keySelector,
            Func<TSource, E> elementSelector,
            Func2<K, Enumerable<E>, R> resultSelector);

    public <I, K, R> Enumerable<R> groupJoin(Enumerable<I> inner,
            Func<TSource, K> outerKeySelector, Func<I, K> innerKeySelector,
            Func2<TSource, Enumerable<I>, R> resultSelector);

    public Enumerable<TSource> intersect(Enumerable<TSource> second);

    public <I, K, R> Enumerable<R> join(Enumerable<I> inner,
            Func<TSource, K> outerKeySelector, Func<I, K> innerKeySelector,
            Func2<TSource, I, R> resultSelector);

    public TSource last();

    public TSource last(Func<TSource, Boolean> predicate);

    public TSource lastOrDefault();

    public TSource lastOrDefault(TSource defaultValue);

    public TSource lastOrDefault(Func<TSource, Boolean> predicate);

    public TSource lastOrDefault(Func<TSource, Boolean> predicate,
            TSource defaultValue);

    public long longCount();

    public long longCount(Func<TSource, Boolean> predicate);

    public TSource max();

    public <R extends Comparable<R>> R max(Func<TSource, R> selector);

    public TSource min();

    public <R extends Comparable<R>> R min(Func<TSource, R> selector);

    public <R> Enumerable<R> ofType(Class<R> resultClass);

    public <K> OrderedEnumerable<TSource> orderBy(Func<TSource, K> keySelector);

    public <K> OrderedEnumerable<TSource> orderBy(Func<TSource, K> keySelector,
            Comparator<K> comparator);

    public <K> OrderedEnumerable<TSource> orderByDescending(
            Func<TSource, K> keySelector);

    public <K> OrderedEnumerable<TSource> orderByDescending(
            Func<TSource, K> keySelector, Comparator<K> comparator);

    public Enumerable<TSource> reverse();

    public <R> Enumerable<R> select(Func2<TSource, Integer, R> selector);

    public <R> Enumerable<R> select(Func<TSource, R> selector);

    public <R> Enumerable<R> selectMany(Func<TSource, Enumerable<R>> selector);

    public <R> Enumerable<R> selectMany(
            Func2<TSource, Integer, Enumerable<R>> selector);

    public <C, R> Enumerable<R> selectMany(
            Func<TSource, Enumerable<C>> collectionSelector,
            Func2<TSource, C, R> resultSelector);

    public <C, R> Enumerable<R> selectMany(
            Func2<TSource, Integer, Enumerable<C>> collectionSelector,
            Func2<TSource, C, R> resultSelector);

    public Boolean sequenceEqual(Enumerable<TSource> second);

    public TSource single();

    public TSource single(Func<TSource, Boolean> predicate);

    public TSource singleOrDefault();

    public TSource singleOrDefault(TSource defaultValue);

    public TSource singleOrDefault(Func<TSource, Boolean> predicate);

    public TSource singleOrDefault(Func<TSource, Boolean> predicate,
            TSource defaultValue);

    public Enumerable<TSource> skip(int count);

    public Enumerable<TSource> skipWhile(Func<TSource, Boolean> predicate);

    public Enumerable<TSource> skipWhile(
            Func2<TSource, Integer, Boolean> predicate);

    public int sum();

    public long sumLong();

    public float sumFloat();

    public double sumDouble();

    public int sum(Func<TSource, Integer> selector);

    public long sumLong(Func<TSource, Long> selector);

    public float sumFloat(Func<TSource, Float> selector);

    public double sumDouble(Func<TSource, Double> selector);

    public Enumerable<TSource> take(int count);

    public Enumerable<TSource> takeWhile(Func<TSource, Boolean> predicate);

    public Enumerable<TSource> takeWhile(
            Func2<TSource, Integer, Boolean> predicate);

    public Object[] toArray();

    public <R> R[] toArray(Class<R> resultClass);

    public <K> Map<K, TSource> toMap(Func<TSource, K> keySelector);

    public <K, E> Map<K, E> toMap(Func<TSource, K> keySelector,
            Func<TSource, E> elementSelector);

    public <K> Dictionary<K, TSource> toDictionary(Func<TSource, K> keySelector);

    public <K, E> Dictionary<K, E> toDictionary(Func<TSource, K> keySelector,
            Func<TSource, E> elementSelector);

    public List<TSource> toList();

    public EnumerableList<TSource> toEnumerableList();

    public <K> Map<K, List<TSource>> toListMap(Func<TSource, K> keySelector);

    public <K, E> Map<K, List<E>> toListMap(Func<TSource, K> keySelector,
            Func<TSource, E> elementSelector);

    public <K> Lookup<K, TSource> toLookup(Func<TSource, K> keySelector);

    public <K, E> Lookup<K, E> toLookup(Func<TSource, K> keySelector,
            Func<TSource, E> elementSelector);

    public Enumerable<TSource> union(Enumerable<TSource> second);

    public Enumerable<TSource> where(Func<TSource, Boolean> predicate);

    public Enumerable<TSource> where(Func2<TSource, Integer, Boolean> predicate);
}
