package sharin.unlinq;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

public abstract class QueuedIterator<T, E, R> implements Iterator<R> {

    private final Iterator<T> iterator;

    private Queue<E> queue = new LinkedList<E>();

    public QueuedIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    protected abstract void addElement(Queue<E> queue, T t);

    protected abstract R toResult(E e);

    public boolean hasNext() {

        // if done
        if (queue == null) {
            return false;
        }

        // if reserved
        if (!queue.isEmpty()) {
            return true;
        }

        while (iterator.hasNext()) {
            addElement(queue, iterator.next());

            if (!queue.isEmpty()) {
                return true;
            }
        }

        // done
        queue = null;
        return false;
    }

    public R next() {

        // done
        if (queue == null) {
            throw new NoSuchElementException();
        }

        // unreserved
        if (queue.isEmpty()) {

            if (!hasNext()) {
                throw new NoSuchElementException();
            }
        }

        return toResult(queue.remove());
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}
