package sharin.unlinq.iterable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import sharin.unlinq.BasicEnumerable;
import sharin.unlinq.Enumerable;
import sharin.unlinq.Func;
import sharin.unlinq.Func2;

public class GroupJoinIterable<O, I, K, R> implements Iterable<R> {

    private final Iterable<O> outer;

    private final Iterable<I> inner;

    private final Func<O, K> outerKeySelector;

    private final Func<I, K> innerKeySelector;

    private final Func2<O, Enumerable<I>, R> resultSelector;

    public GroupJoinIterable(Iterable<O> outer, Iterable<I> inner,
            Func<O, K> outerKeySelector, Func<I, K> innerKeySelector,
            Func2<O, Enumerable<I>, R> resultSelector) {

        this.outer = outer;
        this.resultSelector = resultSelector;
        this.innerKeySelector = innerKeySelector;
        this.outerKeySelector = outerKeySelector;
        this.inner = inner;
    }

    public Iterator<R> iterator() {

        return new Iterator<R>() {

            private final Iterator<O> iterator = outer.iterator();

            private final Map<K, List<I>> innerListMap;

            {
                innerListMap = new HashMap<K, List<I>>();

                for (I i : inner) {
                    K innerKey = innerKeySelector.call(i);
                    List<I> innerList = innerListMap.get(innerKey);

                    if (innerList == null) {
                        innerList = new ArrayList<I>();
                        innerListMap.put(innerKey, innerList);
                    }

                    innerList.add(i);
                }
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public R next() {
                O o = iterator.next();
                K outerKey = outerKeySelector.call(o);
                List<I> innerList = innerListMap.get(outerKey);
                return resultSelector
                        .call(o, new BasicEnumerable<I>(innerList));
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}
