package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RepeatIterable<R> implements Iterable<R> {

    private final int count;

    private final R element;

    public RepeatIterable(int count, R element) {
        this.count = count;
        this.element = element;
    }

    public Iterator<R> iterator() {

        return new Iterator<R>() {

            private int index;

            public boolean hasNext() {
                return index < count;
            }

            public R next() {

                if (index >= count) {
                    throw new NoSuchElementException();
                }

                index++;
                return element;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}
