package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class TakeIterable<T> implements Iterable<T> {

    private final Iterable<T> iterable;

    private final int count;

    public TakeIterable(Iterable<T> iterable, int count) {
        this.iterable = iterable;
        this.count = count;
    }

    public Iterator<T> iterator() {
        return new Iterator<T>() {

            private final Iterator<T> iterator = iterable.iterator();

            private int index;

            public boolean hasNext() {

                if (index >= count) {
                    return false;
                }

                return iterator.hasNext();
            }

            public T next() {

                if (index >= count) {
                    throw new NoSuchElementException();
                }

                index++;
                return iterator.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}
