package sharin.unlinq.iterable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

import sharin.unlinq.ConcatenatedIterator;
import sharin.unlinq.QueuedIterator;

public class UnionIterable<T> implements Iterable<T> {

    private final Iterable<T> first;

    private final Iterable<T> second;

    public UnionIterable(Iterable<T> first, Iterable<T> second) {
        this.first = first;
        this.second = second;
    }

    public Iterator<T> iterator() {
        return new QueuedIterator<T, T, T>(new ConcatenatedIterator<T>(first
                .iterator(), second)) {

            private final Set<T> set = new HashSet<T>();

            @Override
            protected void addElement(Queue<T> queue, T t) {

                if (!set.contains(t)) {
                    queue.add(t);
                    set.add(t);
                }
            }

            @Override
            protected T toResult(T e) {
                return e;
            }
        };
    }
}
