// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="none" email=""/>
//     <version>$Revision: 915 $</version>
// </file>

using System;

namespace ICSharpCode.NRefactory.Parser.AST
{
	[Flags]
	public enum Modifier // TODO: Rename to Modifiers
	{
		None      = 0x0000,
		
		// Access
		Private   = 0x0001,
		/// <summary>C# 'internal', VB 'Friend'</summary>
		Internal  = 0x0002,
		Protected = 0x0004,
		Public    = 0x0008,
		Dim	      = 0x0010,	// VB.NET SPECIFIC
		
		// Scope
		Abstract  = 0x0010,  // == 	MustOverride/MustInherit
		Virtual   = 0x0020,
		Sealed    = 0x0040,
		/// <summary>C# 'static', VB 'Shared'</summary>
		Static    = 0x0080,
		Override  = 0x0100,
		/// <summary>For fields: readonly (c# and vb), for properties: get-only (vb)</summary>
		ReadOnly  = 0x0200,
		Const	  = 0x0400,
		/// <summary>C# 'new', VB 'Shadows'</summary>
		New       = 0x0800,
		Partial   = 0x1000,
		
		// Special
		Extern     = 0x2000,
		Volatile   = 0x4000,
		Unsafe     = 0x8000,
		Overloads  = 0x10000, // VB specific
		WithEvents = 0x20000, // VB specific
		Default    = 0x40000, // VB specific
		Narrowing  = 0x80000, // VB specific
		Widening   = 0x100000, // VB specific
		Synthetic  = 0x200000,
		/// <summary>Only for VB properties.</summary>
		WriteOnly  = 0x400000, // VB specific
		
		Classes                         = New | Public | Protected | Internal | Private | Abstract | Sealed | Partial | Static,
		VBModules						= Private | Public | Protected | Internal,
		VBStructures					= Private | Public | Protected | Internal | New,
		VBEnums						    = Private | Public | Protected | Internal | New,
		VBInterfacs					    = Private | Public | Protected | Internal | New,
		VBDelegates					    = Private | Public | Protected | Internal | New,
		VBMethods						= Private | Public | Protected | Internal | New | Static | Virtual | Sealed | Abstract | Override | Overloads,
		VBExternalMethods				= Private | Public | Protected | Internal | New | Overloads,
		VBEvents						= Private | Public | Protected | Internal | New | Overloads,
		VBProperties					= VBMethods | Default | ReadOnly | WriteOnly,
		VBCustomEvents					= Private | Public | Protected | Internal | New | Overloads,
		VBOperators						= Public  | Static | Overloads | New | Widening | Narrowing,
		
		
		// this is not documented in the spec
		VBInterfaceEvents				= New,
		VBInterfaceMethods				= New | Overloads,
		VBInterfaceProperties			= New | Overloads | ReadOnly | WriteOnly | Default,
		VBInterfaceEnums				= New,
		
		Fields                          = New | Public | Protected | Internal | Private | Static   | ReadOnly | Volatile,
		PropertysEventsMethods          = New | Public | Protected | Internal | Private | Static   | Virtual  | Sealed   | Override | Abstract | Extern,
		Indexers                        = New | Public | Protected | Internal | Private | Virtual  | Sealed   | Override | Abstract | Extern,
		Operators                       = Public | Static | Extern,
		Constants                       = New | Public | Protected | Internal | Private,
		StructsInterfacesEnumsDelegates = New | Public | Protected | Internal | Private | Partial,
		StaticConstructors              = Extern | Static | Unsafe,
		Destructors                     = Extern | Unsafe,
		Constructors                    = Public | Protected | Internal | Private | Extern,
	}
	
	public enum ClassType
	{
		Class,
		Module,
		Interface,
		Struct,
		Enum
	}
	
	public enum ParentType
	{
		ClassOrStruct,
		InterfaceOrEnum,
		Namespace,
		Unknown
	}
	
	public enum FieldDirection
	{
		None,
		In,
		Out,
		Ref
	}
	
	[Flags]
	public enum ParamModifier // TODO: Rename to ParamModifiers
	{
		// Values must be the same as in SharpDevelop's ParameterModifiers
		None = 0,
		In  = 1,
		Out = 2,
		Ref = 4,
		Params = 8,
		Optional = 16
	}
}
