// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="none" email=""/>
//     <version>$Revision: 915 $</version>
// </file>

using System;
using System.Diagnostics;
using System.Collections;

namespace ICSharpCode.NRefactory.Parser.AST 
{
	public class LabelStatement : Statement
	{
		string label;
		
		public string Label {
			get {
				return label;
			}
			set {
				label = value == null ? String.Empty : value;
			}
		}
		
		public LabelStatement(string label)
		{
			this.Label = label;
		}
		
		public override object AcceptVisitor(IASTVisitor visitor, object data)
		{
			return visitor.Visit(this, data);
		}
		
		public override string ToString()
		{
			return String.Format("[LabelStatement: Label={0}]",
			                     label);
		}
	}
}
