﻿// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Mike Krüger" email="mike@icsharpcode.net"/>
//     <version>$Revision: 915 $</version>
// </file>

using System;
using System.Drawing;
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;

namespace ICSharpCode.NRefactory.Parser.AST
{
	public class EventDeclaration : ParametrizedNode
	{
		TypeReference   typeReference = TypeReference.Null;
		List<InterfaceImplementation> interfaceImplementations = new List<InterfaceImplementation>(1);
		EventAddRegion addRegion       = EventAddRegion.Null;
		EventRemoveRegion removeRegion = EventRemoveRegion.Null;
		EventRaiseRegion raiseRegion   = EventRaiseRegion.Null;
		Point           bodyStart = new Point(-1, -1);
		Point           bodyEnd = new Point(-1, -1);
		
		public TypeReference TypeReference {
			get {
				return typeReference;
			}
			set {
				typeReference = TypeReference.CheckNull(value);
			}
		}
		
		public EventAddRegion AddRegion {
			get {
				return addRegion;
			}
			set {
				addRegion = value == null ? EventAddRegion.Null : value;
			}
		}
		public EventRemoveRegion RemoveRegion {
			get {
				return removeRegion;
			}
			set {
				removeRegion = value == null ? EventRemoveRegion.Null : value;
			}
		}
		public EventRaiseRegion RaiseRegion {
			get {
				return raiseRegion;
			}
			set {
				raiseRegion = value == null ? EventRaiseRegion.Null : value;
			}
		}
		
		public bool HasAddRegion {
			get {
				return !addRegion.IsNull;
			}
		}
		public bool HasRemoveRegion {
			get {
				return !removeRegion.IsNull;
			}
		}
		public bool HasRaiseRegion {
			get {
				return !raiseRegion.IsNull;
			}
		}
		
		public Point BodyStart {
			get {
				return bodyStart;
			}
			set {
				bodyStart = value;
			}
		}
		public Point BodyEnd {
			get {
				return bodyEnd;
			}
			set {
				bodyEnd = value;
			}
		}
		
		public List<InterfaceImplementation> InterfaceImplementations {
			get {
				return interfaceImplementations;
			}
			set {
				interfaceImplementations = value ?? new List<InterfaceImplementation>();
			}
		}
		
		public EventDeclaration(Modifier modifier, List<AttributeSection> attributes) : base(modifier, attributes)
		{
		}
		
		public EventDeclaration(TypeReference typeReference, string name, Modifier modifier, List<AttributeSection> attributes)  : base(modifier, attributes, name)
		{
			this.TypeReference = typeReference;
		}
		
		// for VB:
		public EventDeclaration(TypeReference typeReference, Modifier modifier, List<ParameterDeclarationExpression> parameters, List<AttributeSection> attributes, string name, List<InterfaceImplementation> interfaceImplementations)  : base(modifier, attributes, name, parameters)
		{
			this.TypeReference = typeReference;
			this.InterfaceImplementations = interfaceImplementations;
		}
		
		public override object AcceptVisitor(IASTVisitor visitor, object data)
		{
			return visitor.Visit(this, data);
		}
		public override string ToString()
		{
			return String.Format("[EventDeclaration: TypeReference={0}, Modifier={1}, Attributes={2}, Name={3}, BodyStart={4}, BodyEnd={5}]",
			                     TypeReference,
			                     Modifier,
			                     GetCollectionString(Attributes),
			                     Name,
			                     BodyStart,
			                     BodyEnd);
		}
		
	}
}
