﻿// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="David Srbecký" email="dsrbecky@gmail.com"/>
//     <version>$Revision: 1085 $</version>
// </file>

using System;
using System.Diagnostics.SymbolStore;
using System.Collections;
using System.Runtime.InteropServices;

using Debugger.Wrappers.CorDebug;

namespace Debugger
{
	public class Breakpoint: RemotingObjectBase
	{
		NDebugger debugger;

		SourcecodeSegment sourcecodeSegment;
		
		bool hadBeenSet = false;
		bool enabled = true;
		ICorDebugFunctionBreakpoint corBreakpoint;
		IntPtr pBreakpoint;
		
		public NDebugger Debugger {
			get {
				return debugger;
			}
		}
		
		public SourcecodeSegment SourcecodeSegment {
			get {
				return sourcecodeSegment;
			}
		}
		
		public bool HadBeenSet { 
			get { 
				return hadBeenSet;
			}
			internal set {
				hadBeenSet = value;
				OnChanged();
			}
		}
		
		public bool Enabled {
			get {
				return enabled;
			}
			set	{
				enabled = value;
				if (HadBeenSet) {
					corBreakpoint.Activate(enabled?1:0);
				}
				OnChanged();
			}
		}
		

		public event EventHandler<BreakpointEventArgs> Changed;

		protected void OnChanged()
		{
			if (Changed != null) {
				Changed(this, new BreakpointEventArgs(this));
			}
		}

		public event EventHandler<BreakpointEventArgs> Hit;

		internal void OnHit()
		{
			if (Hit != null) {
				Hit(this, new BreakpointEventArgs(this));
			}
		}

		internal Breakpoint(NDebugger debugger, SourcecodeSegment sourcecodeSegment, bool enabled)
		{
			this.debugger = debugger;
			this.sourcecodeSegment = sourcecodeSegment;
			this.enabled = enabled;
		}
		
		internal bool Equals(IntPtr ptr) 
		{
			return pBreakpoint == ptr;
		}
				
		internal bool Equals(ICorDebugFunctionBreakpoint obj) 
		{
			return corBreakpoint == obj;
		}
		
		public override bool Equals(object obj) 
		{
			return base.Equals(obj) || corBreakpoint == (obj as ICorDebugFunctionBreakpoint);
		}
		
		public override int GetHashCode() 
		{
			return base.GetHashCode();
		}
		
		internal void MarkUnset()
		{
			HadBeenSet = false;
		}
		
		public bool SetBreakpoint()
		{
			if (hadBeenSet) {
				return true;
			}

			ICorDebugFunction corFunction;
			int ilOffset;
			if (!sourcecodeSegment.GetFunctionAndOffset(debugger, false, out corFunction, out ilOffset)) {
				return false;
			}
			
			corBreakpoint = corFunction.ILCode.CreateBreakpoint((uint)ilOffset);
			
			hadBeenSet = true;
			corBreakpoint.Activate(enabled?1:0);
			pBreakpoint = Marshal.GetComInterfaceForObject(corBreakpoint.WrappedObject, typeof(Debugger.Interop.CorDebug.ICorDebugFunctionBreakpoint));
			
			OnChanged();
			
			return true;
		}
	}
}
