// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="Georg Brandl" email="g.brandl@gmx.net"/>
//     <version>$Revision: 915 $</version>
// </file>

using System;
using System.Windows.Forms;
using System.Drawing;
using System.Collections;
using System.Xml;
using System.Xml.Schema;

namespace ICSharpCode.SharpDevelop.AddIns.HighlightingEditor.Nodes
{
	class SchemeNode : AbstractNode
	{
		string name;
		string[] extensions;
		
		public string[] Extensions {
			get {
				return extensions;
			} 
			set {
				extensions = value;
			}
		}
		
		public string Name {
			get {
				return name;
			}
			set {
				name = value;
			}
		}
		
		EnvironmentNode envNode;
		DigitsNode digitsNode;
		PropertiesNode propNode;
		RuleSetsNode rulesetsNode;
		
		string content;
		
		public string Content {
			get {
				return content;
			}
		}
		
		public SchemeNode(XmlElement el, bool readChildren)
		{
			content = el.OuterXml;
			
			name = el.Attributes["name"].InnerText;
			
			if (el.Attributes["extensions"] != null) {
				extensions = el.Attributes["extensions"].InnerText.Split('|');
			}
			
			UpdateNodeText();

			panel = new SchemeOptionPanel(this);

			if (!readChildren) return;
			
			envNode = new EnvironmentNode(el["Environment"]);
			digitsNode = new DigitsNode(el["Digits"]);
			propNode = new PropertiesNode(el["Properties"]);
			rulesetsNode = new RuleSetsNode(el);
			
			Nodes.Add(envNode);
			Nodes.Add(digitsNode);
			Nodes.Add(propNode);
			Nodes.Add(rulesetsNode);
		}
		
		public override void UpdateNodeText()
		{
			Text = name;
		}
		
		public override string ToXml()
		{
			string str = 
				"<?xml version=\"1.0\"?>\n" + 
				"<!-- This file was autogenerated by the #Develop highlighting editor. -->\n\n" +
				"<SyntaxDefinition name=\"" + ReplaceXmlChars(name) + "\" extensions=\"" + String.Join("|", extensions) + "\">\n\n";
			
			str += envNode.ToXml();
			str += propNode.ToXml();
			str += digitsNode.ToXml();
			str += rulesetsNode.ToXml();

			str += 
				"</SyntaxDefinition>\n";
			
			return str;

		}
	}
	
	class SchemeOptionPanel : NodeOptionPanel
	{
		private System.Windows.Forms.TextBox extBox;
		private System.Windows.Forms.TextBox nameBox;
		
		public SchemeOptionPanel(SchemeNode parent) : base(parent)
		{
			SetupFromXmlStream(this.GetType().Assembly.GetManifestResourceStream("Resources.Scheme.xfrm"));
			nameBox = (TextBox)ControlDictionary["nameBox"];
			extBox  = (TextBox)ControlDictionary["extBox"];
		}
		
		public override void StoreSettings()
		{
			SchemeNode node = (SchemeNode)parent;
			node.Name = nameBox.Text;
			node.Extensions = extBox.Text.Split(';');
		}
		
		public override void LoadSettings()
		{
			SchemeNode node = (SchemeNode)parent;
			nameBox.Text = node.Name;
			extBox.Text = String.Join(";", node.Extensions);
		}
		
		public override bool ValidateSettings()
		{
			if (nameBox.Text == "") {
				ValidationMessage("${res:Dialog.HighlightingEditor.Scheme.NameEmpty}");
				return false;
			}
			
			return true;
		}
	}
}
