//------------------------------------------------------------------------------
// <autogenerated>
//     This code was generated by a tool.
//     Runtime Version: 1.1.4322.2032
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </autogenerated>
//------------------------------------------------------------------------------

namespace SharpReportCore {
	
	using System;
	using System.Globalization;
	using System.ComponentModel;
	using System.Collections;
	using SharpReportCore;
	
	/// <summary>
	/// This Class handles all List's with IList
	/// Access to Data is allway#s done by using the 'IndexList'
	/// </summary>
	
	public class CollectionStrategy : BaseListStrategy {
		// Holds the plain Data
		private SharpArrayList baseList;

		private Type	itemType;
		private object firstItem;
		private object current;
		
		private PropertyDescriptorCollection listProperties;
		
		public CollectionStrategy(IList list,string dataMember,ReportSettings reportSettings):base(reportSettings) {
			if (list.Count > 0) {
				firstItem = list[0];
				itemType =  firstItem.GetType();
				this.baseList = new SharpArrayList(itemType,dataMember);
				this.baseList.AddRange(list);
				this.baseList.CurrentPosition = 0;
				this.current = this.baseList[0];
			}
		}
		

		private void BuildGroup(){
//			throw new NotImplementedException("No grouping at the time");
			return;
		}
		
		private PropertyDescriptor[] BuildSortProperties (ColumnCollection col){
			PropertyDescriptor[] sortProperties = new PropertyDescriptor[col.Count];
			PropertyDescriptorCollection c = this.baseList.GetItemProperties(null);
			
			for (int criteriaIndex = 0; criteriaIndex < col.Count; criteriaIndex++){
				PropertyDescriptor descriptor = c.Find (col[criteriaIndex].ColumnName,true);
		
				if (descriptor == null){
					throw new InvalidOperationException(String.Format(CultureInfo.CurrentCulture,
					                                                  "Die Liste enthlt keine Spalte [{0}].",
					                                                  col[criteriaIndex].ColumnName));
				}
				sortProperties[criteriaIndex] = descriptor;
			}
			return sortProperties;
		}
		
		#region Index Building
		
		//Sorted Indexlist
		private  ArrayList BuildSortIndex(ColumnCollection col) {

			PropertyDescriptor[] sortProperties = BuildSortProperties (col);
		
			// bertragen der zu sortierenden Werte in eine standartComparer Auflistung
			ArrayList sortValues = new ArrayList(this.baseList.Count);
			try {
				for (int rowIndex = 0; rowIndex < this.baseList.Count; rowIndex++){
					object rowItem = this.baseList[rowIndex];
					object[] values = new object[col.Count];
					
					// Hier bereits Wertabruf um dies nicht whrend des Sortierens tun zu mssen.
					for (int criteriaIndex = 0; criteriaIndex < sortProperties.Length; criteriaIndex++){
						object value = sortProperties[criteriaIndex].GetValue(rowItem);
						// Hier auf Vertrglichkeit testen um Vergleiche bei Sortierung zu vereinfachen.
						// Muss IComparable und gleicher Typ sein.
						
						if (value != null && value != DBNull.Value)
						{
							if (!(value is IComparable)){
								throw new InvalidOperationException("ReportDataSource:BuildSortArray - > This type doesn't support IComparable." + value.ToString());
							}
							
							values[criteriaIndex] = value;
						}
					}
					sortValues.Add(new SortComparer(col, rowIndex, values));
				}
			} catch (Exception) {
				throw ;
			}
			
			sortValues.Sort();
			return sortValues;
		}
		
		// if we have no sorting, we build the indexlist as well, so we don't need to
		//check each time we reasd data if we have to go directly or by IndexList
		
		private  ArrayList BuildPlainIndex(ColumnCollection col) {
			
			PropertyDescriptor[] sortProperties = new PropertyDescriptor[1];
			PropertyDescriptorCollection c = this.baseList.GetItemProperties(null);
			PropertyDescriptor descriptor = c[0];
			sortProperties[0] = descriptor;
			ArrayList sortValues = new ArrayList(this.baseList.Count);
			try {
				for (int rowIndex = 0; rowIndex < this.baseList.Count; rowIndex++){
					object[] values = new object[1];
					
					// We insert only the RowNr as a dummy value
					values[0] = rowIndex;
					sortValues.Add(new BaseComparer(col, rowIndex, values));
				}
			} catch (Exception) {
				throw ;
			}
			return sortValues;;
		}
		
		
		#endregion
		
		#region SharpReportCore.IDataViewStrategy interface implementation
		
		public override ColumnCollection AvailableFields {
			get {
				ColumnCollection c = base.AvailableFields;
				foreach (PropertyDescriptor p in baseList.GetItemProperties(null)){
					c.Add (new AbstractColumn(p.Name,p.ComponentType));
					}
				return c;
			}
		}
		
		public override int Count {
			get {
				return this.baseList.Count;
			}
		}
		
		public override  int CurrentRow {
			get {
				return base.IndexList.CurrentPosition;
			}
			
			set {
				base.CurrentRow = value;

				current = this.baseList[((BaseComparer)base.IndexList[value]).ListIndex];
			}
		}

		
		public override void Sort() {
			base.Sort();
			ArrayList sortedArray = new ArrayList();
			try {
				ColumnCollection sortColumnCollection = base.ReportSettings.SortColumnCollection;
				if (sortColumnCollection != null) {
					if (sortColumnCollection.Count > 0) {
						sortedArray =  this.BuildSortIndex (sortColumnCollection);
						base.IsSorted = true;
					} else {
						sortedArray =  BuildPlainIndex (sortColumnCollection);
						base.IsSorted = false;
					}
				}
				
				base.IndexList.Clear();
				base.IndexList.AddRange (sortedArray);
//				base.CheckSortArray (sortedArray,"CollectionStrategy - CheckSortArray");
			} catch (Exception) {
				throw;
			}
			
			if (base.IndexList == null){
				throw new NotSupportedException("Sortieren fr die Liste nicht untersttzt.");
			}
		}
		
		
		public override void Reset() {
			this.CurrentRow = 0;
			base.Reset();
		}
		
		
		
		
		public override void Bind() {
			base.Bind();
			if (base.IndexList.Count > 0) {
				base.IndexList.Clear();
			}
			this.listProperties = this.baseList.GetItemProperties(null);
			
			if ((base.ReportSettings.GroupColumnsCollection != null) && (base.ReportSettings.GroupColumnsCollection.Count > 0)) {
				BuildGroup ();
			}
			
			this.Sort ();
			this.Reset();
			base.NotifyResetList();
		}
		
		public override void Fill(IItemRenderer item) {
			base.Fill(item);
			if (current != null) {
				try {
					BaseDataItem baseDataItem = item as BaseDataItem;
					PropertyDescriptor p = this.listProperties.Find (baseDataItem.ColumnName,true);
					
					if (baseDataItem != null) {
						baseDataItem.DbValue = "";
						baseDataItem.DbValue = p.GetValue(this.current).ToString();
					}
				} catch (Exception) {
					
				}
			}
		}
		#endregion
		
	}
}
