//------------------------------------------------------------------------------
// <autogenerated>
//     This code was generated by a tool.
//     Runtime Version: 1.1.4322.2032
//
//     Changes to this file may cause incorrect behavior and will be lost if 
//     the code is regenerated.
// </autogenerated>
//------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Drawing.Printing;
using System.ComponentModel;
	
using SharpReportCore;
/// <summary>
/// This class build a TableLayout
/// </summary>

namespace ReportGenerator {	
	public class TableLayout : AbstractLayout  {
		
		int colWidth;
		Font defaultFont;
		
		public TableLayout(ReportModel reportModel):base(reportModel) {
		}
		
		#region ReportGenerator.IReportLayout interface implementation
	
		public override void BuildLayout() {
			ReportSettings settings = base.ReportModel.ReportSettings;
			PageSettings page = base.ReportModel.ReportSettings.PageSettings;

			defaultFont = base.ReportModel.ReportSettings.DefaultFont;
			
			int gesWidth = page.Bounds.Width - settings.DefaultMargins.Left - settings.DefaultMargins.Right;
			// first we build the DetailSection
			BaseSection sec = base.ReportModel.DetailSection;
			
			this.colWidth = gesWidth / sec.Items.Count;
			
			// we use GlobalValues.GridSize.Width as Gap 
			//between to controls

			FormatSection (base.ReportModel.DetailSection,this.colWidth,
		               0,GlobalValues.GridSize.Width);
		
			//ReportHeader
			sec = base.ReportModel.ReportHeader;
			if (sec.Items.Count > 0) {
				throw new NotImplementedException("FormatReportHeader");
			}
			
			
			// here we build the PageHeader, we use the columnsWidth from Details
			// but we start at position 1 in ItemsCollection
			sec = base.ReportModel.PageHeader;
			this.colWidth = gesWidth / (sec.Items.Count - 1);
			FormatSection (sec,this.colWidth,
			               1,GlobalValues.GridSize.Width);
			
			base.FormatSingleEntry(sec.Items[0],
			                       this.colWidth,new Point(settings.DefaultMargins.Left,0),defaultFont);
			
			//PageFooter
			sec = base.ReportModel.PageFooter;
			base.FormatSingleEntry(sec.Items[0],
			                       this.colWidth,new Point(settings.DefaultMargins.Left,0),defaultFont);
			
			//ReportFooter
			sec = base.ReportModel.ReportFooter;
			if (sec.Items.Count > 0) {
				throw new NotImplementedException("FormatReportFooter");
			}
		}
		#endregion
		
		private void FormatSection (BaseSection section,
		                            int itemWidth,int startAt,
		                            int gap){
			
			IItemRenderer rItem;
			ReportItemCollection collection = section.Items;
			int leftMargin = base.ReportModel.ReportSettings.DefaultMargins.Left;
			int pos = 0;
			for (int i = startAt;i < collection.Count ;i++ ) {
				rItem = collection[i];
				rItem.Location = new Point (leftMargin + (pos * itemWidth),rItem.Location.Y);
				rItem.Size = new Size (itemWidth - gap,rItem.Size.Height + GlobalValues.EnlargeControl);
				rItem.Font =  defaultFont;
				pos ++;
			}
		}
		

	}
}
