//------------------------------------------------------------------------------
// <autogenerated>
//     This code was generated by a tool.
//     Runtime Version: 1.1.4322.2032
//
//     Changes to this file may cause incorrect behavior and will be lost if 
//     the code is regenerated.
// </autogenerated>
//------------------------------------------------------------------------------


using System;
using System.Globalization;
using System.Text;
using System.Drawing;
using System.Drawing.Printing;
//// Alex: for spooler
using System.ServiceProcess;
	
/// <summary>
/// This Class contains Global Icons and Constantes
/// </summary>
/// <remarks>
/// 	created by - Forstmeier Peter
/// 	created on - 19.01.2005 10:57:33
/// </remarks>
	
namespace SharpReportCore {
		public  class GlobalValues : object {
		
		private static string sharpReportString = "SharpReport";
		private static string sharpReportExtension = ".srd";
		private static string xsdExtension = "xsd";
		private static string sharpReportStandartFileName = "SharpReport1";
		private const string unbound = "unbound";
		private const int enlargeControl = 5;
		
		#region some usefull functions and methodes
		

//// Alex: check if spooler is running
		private static bool IsSpoolerRunning() {
			ServiceController[] services;
			try {
				services = ServiceController.GetServices();
				foreach (ServiceController sc in services) {
					if (sc.ServiceName.ToLower(CultureInfo.CurrentCulture) == "spooler") {
						if (sc.Status == ServiceControllerStatus.Running) {
							//Console.WriteLine("Spooler running");
							return true;
						} else {
							//Console.WriteLine("Spooler stopped");
							return false;
						}
					}
				}
				return false;
			} catch {
				return false;
			}
		}
		
		/// <summary>
		/// We need at least one installed printer to run SharpReport
		/// </summary>
		public static bool IsValidPrinter () {
			try {
//// Alex: don't try to access PrinterSettings if spooler doesn't run
				if (IsSpoolerRunning()) {
					if (PrinterSettings.InstalledPrinters.Count == 0) {
						return false;
					} else {
						return true;
					}
				} else {
					return false;
				}
			} catch (Exception) {
				return false;
			}
		}
		
		
		#endregion
		
		#region Formatting
		/// <summary>
		/// Build a StringFormat witch is used allover the code to
		/// Format all String's the same way.
		/// </summary>
		/// <returns>a StringFormat object</returns>
		
		public static StringFormat StandartStringFormat() {
			StringFormat sFormat = StringFormat.GenericTypographic;
			sFormat.FormatFlags |= StringFormatFlags.LineLimit;
			
			sFormat.Trimming |= StringTrimming.EllipsisCharacter;
			sFormat.LineAlignment |= StringAlignment.Near;
			return sFormat;
		}
		
		#endregion
		
		#region numeric Constant
		/// <summary>
		/// The value on witch the Control is drawing bigger than the text inside
		/// </summary>
		public static int EnlargeControl {
			get {
				return enlargeControl;
			}
		}
		
		///<summary>
		/// The default Size of a Section
		/// used in <see cref="ReportGenerator"
		/// </summary>
		public static int DefaultSectionHeight {
			get {
				return 40;
			}
		}
		
		public static Size PreferedSize {
			get {
				return new Size(100,20);
			}
		}
		                                  
	
		/// <summary>
		/// Size of Grids in Sections, used by the Designer
		/// <see cref="System.Windows.Forms.ControlPaint.DrawGrid >
		/// </see>		
		/// /// </summary>
		
		public static Size GridSize {
			get {
				return new Size (8,8);
			}
		}
		#endregion
		
		#region String Constant's
		public static string SharpReportString {
  			get {
  				return sharpReportString;
  			}
  		}
		
		public static string SharpReportExtension {
			get {
				return sharpReportExtension;
			}
		}
		
		public static string SharpReportStandartFileName {
			get {
				return sharpReportStandartFileName;
			}
		}
		
		public static string SharpReportPlainFileName{
			get {
				return sharpReportStandartFileName + sharpReportExtension;
			}
		}
		
		public static string UnboundName {
			get {return unbound;}
		}
		#endregion
		
		#region Message's


		/// <summary>
		/// FileFilter for store and load of SharpReport Files
		/// </summary>
		public static string FileFilter {
			get {
				StringBuilder str = new StringBuilder ("SharpReports (*.xml)" + "|" + "*.xml");
				str.Append( "|");
				str.Append("SharpReports (*.srd)" + "|" + "*.srd");
				str.Append("|");
				str.Append("All Files (*.*)" +  "|" + "*.*");
				
				return str.ToString();
			}
		}
		/// <summary>
		/// File Filter for *.Xsd Files
		/// </summary>
		public static string XsdFileFilter {
			get {
				return "XSD Files | *.xsd";
			}
			
		}
		
		public static string XsdExtension {
			get {
				return xsdExtension;
			}
		}
		
		#endregion
		
		
		#region Icons
		
		/// <summary>
		/// ToolboxIcon for ReportRectangle
		/// </summary>
		/// <returns>Bitmap</returns>
		public static Bitmap RectangleBitmap() {
			Bitmap b = new Bitmap (16,16);
			using (Graphics g = Graphics.FromImage (b)){
				g.DrawRectangle (new Pen(Color.Black, 1),
				                 1,1,14,14);
			}
			return b;
		}
		
		/// <summary>
		/// ToolboxIcon for ReportCircle
		/// </summary>
		/// <returns>Bitmap</returns>
		public static Bitmap CircleBitmap() {
			Bitmap b = new Bitmap (19,19);
			using (Graphics g = Graphics.FromImage (b)){
				g.DrawEllipse (new Pen(Color.Black, 1),
				               1,1,
				               17,17);
			}
			return b;
		}
		#endregion
		
	
	}
}
