/*-------------------------------------------------------------------------
Trace.cs -- Trace Output Class
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the 
Free Software Foundation; either version 2, or (at your option) any 
later version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
for more details.

You should have received a copy of the GNU General Public License along 
with this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than 
Coco/R itself) does not fall under the GNU General Public License.
-------------------------------------------------------------------------*/
using System;
using System.IO;

namespace at.jku.ssw.Coco {

class Trace {
	static string fileName;         /* pdt */
	static StreamWriter trace;
	
	public static void Init (String dir) {
		fileName = dir + "trace.txt";  /* pdt */
		try {
			trace = new StreamWriter(new FileStream(fileName, FileMode.Create));
		} catch (IOException) {
			Errors.Exception("-- could not open " + fileName);
		}
	}

	public static void Write (string s) { trace.Write(s); }

	public static void Write (string s, params object[] args) {
		trace.Write(s, args);
	}

	public static void WriteLine (string s) { trace.WriteLine(s); }
	
	public static void WriteLine (string s, params object[] args) {
		trace.WriteLine(s, args);
	}
	
	public static void WriteLine () { trace.WriteLine(); }
	
	public static void Close () { /* pdt */
		trace.Close();
		FileInfo f = new FileInfo(fileName);
		if (f.Length == 0) f.Delete();
		else Console.WriteLine("trace output is in " + fileName);
	}

}

}