﻿// <file>
//     <copyright see="prj:///doc/copyright.txt"/>
//     <license see="prj:///doc/license.txt"/>
//     <owner name="David Srbecký" email="dsrbecky@gmail.com"/>
//     <version>$Revision: 1405 $</version>
// </file>

using System;
using System.Windows.Forms;
using System.Drawing;
using System.CodeDom.Compiler;
using System.Collections;
using System.IO;
using System.Diagnostics;
using ICSharpCode.Core;
using ICSharpCode.SharpDevelop.Services;

using Debugger;
using System.Collections.Generic;

namespace ICSharpCode.SharpDevelop.Gui.Pads
{
	public class LocalVarPad : DebuggerPad
	{
		DebuggerTreeListView localVarList;
		
		ColumnHeader name = new ColumnHeader();
		ColumnHeader val  = new ColumnHeader();
		ColumnHeader type = new ColumnHeader();
		
		public override Control Control {
			get {
				return localVarList;
			}
		}
		
		protected override void InitializeComponents()
		{
			//iconsService = (ClassBrowserIconsService)ServiceManager.Services.GetService(typeof(ClassBrowserIconsService));
			localVarList = new DebuggerTreeListView();
			localVarList.SmallImageList = DebuggerIcons.ImageList;
			localVarList.ShowPlusMinus = true;
			localVarList.FullRowSelect = true;
			localVarList.Dock = DockStyle.Fill;
			localVarList.Sorting = SortOrder.Ascending;
			//localVarList.GridLines  = false;
			//localVarList.Activation = ItemActivation.OneClick;
			localVarList.Columns.AddRange(new ColumnHeader[] {name, val, type} );
			name.Width = 250;
			val.Width = 300;
			type.Width = 250;
			localVarList.Visible = false;
			localVarList.SizeChanged += new EventHandler(localVarList_SizeChanged);
			localVarList.BeforeExpand += new TreeListViewCancelEventHandler(localVarList_BeforeExpand);
			
			
			RedrawContent();
		}
		
		public override void RedrawContent()
		{
			name.Text = ResourceService.GetString("Global.Name");
			val.Text  = ResourceService.GetString("Dialog.HighlightingEditor.Properties.Value");
			type.Text = ResourceService.GetString("ResourceEditor.ResourceEdit.TypeColumn");
		}
		
		// This is a walkarond for a visual issue
		void localVarList_SizeChanged(object sender, EventArgs e)
		{
			localVarList.Visible = true;
		}
		
		
		protected override void RegisterDebuggerEvents()
		{
			debuggerCore.DebuggeeStateChanged += delegate { debuggerCore.LocalVariables.Update(); };
		}
		
		public override void RefreshPad()
		{
			localVarList.BeginUpdate();
			localVarList.Items.Clear();
			AddVariableCollectionToTree(debuggerCore.LocalVariables, localVarList.Items);
			localVarList.EndUpdate();
		}
		
		delegate void AddVariableMethod(Variable variable);
		
		public static void AddVariableCollectionToTree(VariableCollection varCollection, TreeListViewItemCollection tree)
		{
			TreeListViewItem privateInstanceMenu = new TreeListViewItem("<Private Members>", 0);
			TreeListViewItem staticMenu = new TreeListViewItem("<Static Members>", 0);
			TreeListViewItem privateStaticMenu = new TreeListViewItem("<Private Static Members>", 0);
			
			AddVariableMethod addVariable = delegate(Variable variable) {
				ClassVariable classVariable = variable as ClassVariable;
				
				if (classVariable == null || classVariable.IsPublic) {
					if (classVariable != null && classVariable.IsStatic) {
						// Public static
						if (staticMenu.TreeListView == null) {
							tree.Add(staticMenu);
							tree.Sort(false);
						}
						staticMenu.Items.Add(new TreeListViewDebuggerItem(variable));
					} else {
						// Public instance
						tree.Add(new TreeListViewDebuggerItem(variable));
					}
				} else {
					if (classVariable.IsStatic) {
						// Private static
						if (staticMenu.TreeListView == null) {
							tree.Add(staticMenu);
							tree.Sort(false);
						}
						if (privateStaticMenu.TreeListView == null) {
							staticMenu.Items.Add(privateStaticMenu);
							staticMenu.Items.Sort(false);
						}
						privateStaticMenu.Items.Add(new TreeListViewDebuggerItem(variable));
					} else {
						// Private instance
						if (privateInstanceMenu.TreeListView == null) {
							tree.Add(privateInstanceMenu);
							tree.Sort(false);
						}
						privateInstanceMenu.Items.Add(new TreeListViewDebuggerItem(variable));
					}
				}
			};
			
			varCollection.VariableAdded += delegate(object sender, VariableEventArgs e) {
				addVariable(e.Variable);
			};
			
			foreach(Variable variable in varCollection) {
				addVariable(variable);
			}
		}
		
		private void localVarList_BeforeExpand(object sender, TreeListViewCancelEventArgs e)
		{
			if (debuggerCore.IsPaused) {
				if (e.Item is TreeListViewDebuggerItem) {
					((TreeListViewDebuggerItem)e.Item).BeforeExpand();
				}
			} else {
				MessageBox.Show("You can not explore variables while the debuggee is running.");
				e.Cancel = true;
			}
		}
	}
}
