//------------------------------------------------------------------------------
// <autogenerated>
//     This code was generated by a tool.
//     Runtime Version: 1.1.4322.2032
//
//     Changes to this file may cause incorrect behavior and will be lost if 
//     the code is regenerated.
// </autogenerated>
//------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Drawing.Printing;
using System.ComponentModel;
using System.Windows.Forms;

using SharpReportCore;
/// <summary>
/// This class build a TableLayout
/// </summary>

namespace ReportGenerator {	
	public class TableLayout : AbstractLayout  {
		
		int colWidth;
		Font defaultFont;
		
		public TableLayout(ReportModel reportModel):base(reportModel) {
		}
		
		#region ReportGenerator.IReportLayout interface implementation
	
		public override void BuildLayout() {

			defaultFont = base.ReportModel.ReportSettings.DefaultFont;

			// first we build the DetailSection
			BaseSection sec = base.ReportModel.DetailSection;
			
			IContainerItem container = (IContainerItem)sec.Items[0];
			
			Padding gap;
			if (container != null) {
				gap = container.Padding;
			} else {
				gap = base.ReportModel.ReportSettings.Padding;
			}
		
			this.colWidth = (Convert.ToInt32(base.UseablePageWidth / sec.Items.Count)) - gap.Left;
			
			FormatSection (base.ReportModel.DetailSection,this.colWidth,
		               0,gap);
		
			//ReportHeader
			sec = base.ReportModel.ReportHeader;
			if (sec.Items.Count > 0) {
				throw new NotImplementedException("FormatReportHeader");
			}
			
			
			// here we build the PageHeader, we use the columnsWidth from Details
			// but we start at position 1 in ItemsCollection
			sec = base.ReportModel.PageHeader;
			this.colWidth = base.UseablePageWidth / (sec.Items.Count - 1);
			FormatSection (sec,this.colWidth,
			               1,base.ReportModel.ReportSettings.Padding);
			
			base.FormatSingleEntry(sec.Items[0],
			                       this.colWidth,new Point(base.ReportSettings.DefaultMargins.Left,0),defaultFont);
			
			//PageFooter
			sec = base.ReportModel.PageFooter;
			base.FormatSingleEntry(sec.Items[0],
			                       this.colWidth,new Point(base.ReportSettings.DefaultMargins.Left,0),defaultFont);
			
			//ReportFooter
			sec = base.ReportModel.ReportFooter;
			if (sec.Items.Count > 0) {
				throw new NotImplementedException("FormatReportFooter");
			}
		}
		#endregion
		
		private void FormatItems (ReportItemCollection collection, int leftMargin,
		                     int itemWidth,int startAt,Padding gap) {
			
			int pos = 0;
			BaseReportItem item;
			for (int i = startAt;i < collection.Count ;i++ ) {
				item = (BaseReportItem)collection[i];
			
				item.SuspendLayout();
				
				item.Location = new Point (leftMargin + gap.Left + (pos * itemWidth),item.Location.Y);
				item.Size = new Size (itemWidth - gap.Left,item.Size.Height + GlobalValues.EnlargeControl);
				item.Font =  defaultFont;
				IContainerItem con = item as IContainerItem;
				
				if (con != null) {
					item.Size = new Size (base.UseablePageWidth,item.Size.Height);
					int colWidth = item.Size.Width / (con.Items.Count);
					FormatItems (con.Items,0,colWidth,0,gap);
				}
				pos ++;
				item.ResumeLayout();
			}
		}
		
		private void FormatSection (BaseSection section,
		                            int itemWidth,int startAt,
		                            Padding gap){

			int leftMargin = section.SectionMargin;
			FormatItems (section.Items,leftMargin,itemWidth,startAt,gap);
			
		}
		

	}
}
