/*
 * Decompiled with CFR 0.152.
 */
package com.projity.field;

import com.projity.field.Field;
import com.projity.field.FieldParseException;
import com.projity.strings.Messages;
import java.text.MessageFormat;

public class Range {
    private static final String messageErrorRangeMinimum = Messages.getString("Message.errorRangeMinimum.mf");
    private static final String messageErrorRangeMaximum = Messages.getString("Message.errorRangeMaximum.mf");
    private static final String messagePercentErrorRangeMinimum = Messages.getString("Message.errorPercentRangeMinimum.mf");
    private static final String messagePercentErrorRangeMaximum = Messages.getString("Message.errorPercentRangeMaximum.mf");
    double minimum = 0.0;
    double maximum = Double.MAX_VALUE;
    double step = 0.0;
    String errorMessage = null;

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double d2) {
        this.maximum = d2;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double d2) {
        this.minimum = d2;
    }

    public void validate(Object object, Field field) throws FieldParseException {
        if (!(object instanceof Number)) {
            return;
        }
        Number number = (Number)object;
        String string = null;
        if (this.minimum > number.doubleValue()) {
            string = field.isPercent() ? messagePercentErrorRangeMinimum : messageErrorRangeMinimum;
        } else if (this.maximum < number.doubleValue()) {
            String string2 = string = field.isPercent() ? messagePercentErrorRangeMaximum : messageErrorRangeMaximum;
        }
        if (string != null) {
            throw new FieldParseException(this.getFormattedError(number, field, string));
        }
    }

    private String getFormattedError(Number number, Field field, String string) {
        String string2 = this.errorMessage == null ? string : this.errorMessage;
        return MessageFormat.format(string2, new Double(this.minimum), new Double(this.maximum), number, field.getName());
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public final double getStep() {
        return this.step;
    }

    public final void setStep(double d2) {
        this.step = d2;
    }
}

