/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.transform.sorting;

import com.projity.configuration.FieldDictionary;
import com.projity.field.Field;
import com.projity.field.FieldConverter;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.transform.CommonTransform;
import com.projity.grouping.core.transform.HierarchicObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.Closure;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class NodeSorter
extends CommonTransform
implements Comparator {
    protected boolean showSummary = true;
    protected boolean showEmptyLines = true;
    protected boolean showEndEmptyLines = true;
    protected List fields = null;
    protected NodeModel model;
    protected boolean showEmptySummaries = true;
    protected boolean showAssignments = true;
    protected boolean preserveHierarchy = true;
    private GenericObjectPool pool = new GenericObjectPool(new ListFactory());
    protected ListIterator currentSorter = null;

    public NodeModel getModel() {
        return this.model;
    }

    public void setModel(NodeModel nodeModel) {
        this.model = nodeModel;
    }

    public boolean isShowEmptyLines() {
        return this.showEmptyLines;
    }

    public void setShowEmptyLines(boolean bl) {
        this.showEmptyLines = bl;
    }

    public boolean isShowEndEmptyLines() {
        return this.showEndEmptyLines;
    }

    public void setShowEndEmptyLines(boolean bl) {
        this.showEndEmptyLines = bl;
    }

    public boolean isShowSummary() {
        return this.showSummary;
    }

    public void setShowSummary(boolean bl) {
        this.showSummary = bl;
    }

    public boolean isShowEmptySummaries() {
        return this.showEmptySummaries;
    }

    public void setShowEmptySummaries(boolean bl) {
        this.showEmptySummaries = bl;
    }

    public boolean isShowAssignments() {
        return this.showAssignments;
    }

    public void setShowAssignments(boolean bl) {
        this.showAssignments = bl;
    }

    public boolean isPreserveHierarchy() {
        return this.preserveHierarchy;
    }

    public void setPreserveHierarchy(boolean bl) {
        this.preserveHierarchy = bl;
    }

    public List sortList(List list, boolean bl) {
        return this.sortList(list, this, bl);
    }

    public List sortList(List list, Comparator comparator, boolean bl) {
        Collections.sort(list, comparator);
        if (bl) {
            for (HierarchicObject hierarchicObject : list) {
                if (hierarchicObject.getChildren().size() <= 0) continue;
                this.sortList(hierarchicObject.getChildren(), comparator, true);
            }
        }
        return list;
    }

    public List getList() {
        try {
            return (List)this.pool.borrowObject();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void recycleList(List list) {
        try {
            list.clear();
            this.pool.returnObject(list);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setRedefinitionCallBack(Closure closure) {
    }

    protected String getFieldName(String string) {
        Field field = FieldDictionary.getInstance().getFieldFromId(string);
        return field.getName();
    }

    protected String toString(Object object) {
        return FieldConverter.toString(object, object.getClass(), null);
    }

    protected String toString(String string, Object object) {
        Field field = FieldDictionary.getInstance().getFieldFromId(string);
        if (field.hasOptions()) {
            return field.convertValueToStringUsingOptions(object);
        }
        return this.toString(object);
    }

    public String getGroupName(Object object) {
        return "";
    }

    public String getGroupName(String string, Object object) {
        return this.getFieldName(string) + ": " + object;
    }

    public String getStringGroupName(String string, Object object) {
        return string + ": " + object;
    }

    public int compare(Object object, Object object2) {
        List list = this.getSubTransforms();
        if (list != null) {
            this.currentSorter = list.listIterator();
            while (this.currentSorter.hasNext()) {
                NodeSorter nodeSorter = (NodeSorter)this.currentSorter.next();
                int n2 = nodeSorter.compare(object, object2);
                if (n2 == 0) continue;
                this.currentSorter.previous();
                return n2;
            }
        }
        return 0;
    }

    public ListIterator getCurrentSorter() {
        if (this.currentSorter != null) {
            return this.currentSorter;
        }
        if (this.getSubTransforms() == null) {
            return null;
        }
        return this.getSubTransforms().listIterator();
    }

    private class ListFactory
    extends BasePoolableObjectFactory {
        private ListFactory() {
        }

        public Object makeObject() throws Exception {
            return new ArrayList();
        }

        public void activateObject(Object object) throws Exception {
        }
    }
}

